% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_BT.R
\name{predict.BT}
\alias{coef.BT}
\alias{predict.BT}
\title{Make predictions from a "\code{BT}" object.}
\usage{
\method{predict}{BT}(object, newx, s = NULL, iter = NULL,
  type = c("response", "coefficients"), ...)

\method{coef}{BT}(object, s = NULL, iter = NULL, ...)
}
\arguments{
\item{object}{fitted "\code{BT}" object.}

\item{newx}{matrix of new values of design matrix at which predictions are to be made. Ignored
when \code{type=="coefficients"}.}

\item{s}{value of the penalty parameter at which predictions are required. If the value
is not one of the \code{lambda} values present in \code{object} the output will be
etermined by linear interpolation. Default is the entire sequence of \code{lambda}
values present in \code{object}.}

\item{iter}{iteration at which predictions are required. Default is the entire sequence
of iterations in \code{object}.}

\item{type}{of prediction required. Type "\code{response}" gives estimates of the response
whilst type "\code{coefficients}" gives coefficient estimates.}

\item{...}{not used. Other arguments to \code{predict}.}
}
\value{
Either a vector of predictions or, if either \code{s} or \code{iter} are \code{NULL},
 a three-dimensional array with last two dimensions indexing different \code{lambda} values and
 iterations.
}
\description{
Similar to other predict methods, this function predicts fitted values and computes coefficients
from a fitted "\code{BT}" object.
}
\examples{
x <- matrix(rnorm(100*250), 100, 250)
y <- x[, 1] + x[, 2] - x[, 1]*x[, 2] + x[, 3] + rnorm(100)
out <- LassoBT(x, y, iter_max=10)
predict(out, newx=x[1:2, ])
}

