% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LWP.R
\name{LWP}
\alias{LWP}
\title{User Friendly Evaluation of Dose-Effect Experiments using Litchfield-Wilcoxon
and Probit Methods}
\usage{
LWP(rawfile = NULL, descrcolz = 1:4, saveplots = TRUE,
  showplots = FALSE, saveresults = TRUE, showresults = TRUE,
  returnresults = FALSE)
}
\arguments{
\item{rawfile}{A character scalar specifying the path of the input data as a csv file.
If NULL, default, the user will be prompted to browse to a file using a
menu.}

\item{descrcolz}{A numeric vector, the column numbers to use as the description of the
test, default 1:4.}

\item{saveplots}{A logical scalar indicating if plots should be saved to a pdf file,
default TRUE.  See details.}

\item{showplots}{A logical scalar indicating if plots should be shown on screen,
default FALSE.  See details.}

\item{saveresults}{A logical scalar indicating if results should be saved to a csv file,
default TRUE.
The csv file is given the same name (plus the suffix "Smry") and is
placed in the same directory as the input file.}

\item{showresults}{A logical scalar indicating if results should be printed to the console,
default TRUE.
These results include the chi-squared statistic, degrees of freedom, and
p-value for the Litchfield Wilcoxon method.}

\item{returnresults}{A logical scalar indicating if results should be returned by the function,
default FALSE.}
}
\value{
If \code{returnresults=TRUE}, a data frame with 11 rows per test and
    2 more columns than the input data. Three columns from the input data are
    not included (\code{TFM Conc. (mg/L)}, \code{No. Tested}, and
    \code{No. Dead}). Five columns are added: the parameter (\code{param}),
    the method used (\code{method}), the estimate (\code{estimate}), and the
    95\% confidence interval of the estimate (\code{lower95ci} and
    \code{upper95ci})
}
\description{
User friendly evaluation of dose-effect experiments using automated
  Litchfield Wilcoxon (1949) and probit estimation methods.
  This function has been tailored for non-R users with input data set up in a
  particular way (see Details).
}
\details{
The input data must include at least these seven columns,
    with these names in the header row:
  \itemize{
    \item \code{Test ID} = A character or numeric vector,
      the unique identifier for each test
    \item \code{Source} = A character vector, the source of the chemical
    \item \code{Batch} = A character or numeric vector, the batch of the
      chemical
    \item \code{Species} = A character vector, the species tested
    \item \code{TFM Conc. (mg/L)} = A numeric vector, the concentration of
      TFM in mg/L
    \item \code{No. Tested} = A numeric vector, the number of animals tested
    \item \code{No. Dead} = A numeric vector, the number of animals dead
  }

  The input data are expected to be summarized by dose.
    If duplicate doses are provided, an error will be thrown.

  Both \code{saveplots} and \code{showplots} may be set to FALSE, in which
    case no plots will be produced.  But both may not be set to TRUE.
}
\examples{
\dontrun{
LWP()
}
}
\references{
Litchfield, JT Jr. and F Wilcoxon.  1949.
    A simplified method of evaluating dose-effect experiments.
    Journal of Pharmacology and Experimental Therapeutics 96(2):99-113.
    \href{http://jpet.aspetjournals.org/content/96/2/99.abstract}{[link]}.
}

