% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred_rpart.R
\name{Pred.rpart}
\alias{Pred.rpart}
\title{Prediction function for \link[rpart]{rpart.object}}
\usage{
Pred.rpart(formula, train, test)
}
\arguments{
\item{formula}{A formula used to fit the survival tree. The response
is a \link[survival]{Surv} object. If it has the form Surv(time1, time2, event),
then \code{LTRCART} is called internally; if response has the form Surv(time, event),
then the \link[rpart]{rpart} is called internally.}

\item{train}{Training set}

\item{test}{Test set}
}
\value{
A list of predicted KM curves and median survival times.
}
\description{
The output of \code{LTRCART} is an \link[rpart]{rpart} object, and as a result the
usual \link{predict} function on such an object returns the predicted
relative risk on the test set. \code{Pred.rpart} returns the predicted
Kaplan-Meier curves and median survival times on the test set,
which in some circumstances might be desirable in practice.
Note that this function can be applied to any \link[rpart]{rpart} survival tree
object, not just one produced by \code{LTRCART}
}
\examples{
## The Assay of serum free light chain data in survival package
## Adjust data & clean data
library(survival)
library(LTRCtrees)
Data <- flchain
Data <- Data[!is.na(Data$creatinine),]
Data$End <- Data$age + Data$futime/365
DATA <- Data[Data$End > Data$age,]
names(DATA)[6] <- "FLC"

## Setup training set and test set
Train = DATA[1:500,]
Test = DATA[1000:1020,]

## Predict median survival time and Kaplan Meier survival curve
## on test data using Pred.rpart
LTRCART.pred <- Pred.rpart(Surv(age, End, death) ~ sex + FLC + creatinine, Train, Test)
LTRCART.pred$KMcurves  ## list of predicted KM curves
LTRCART.pred$Medians  ## vector of predicted median survival time

}

