% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.ltrcrsf.R
\name{tune.ltrcrsf}
\alias{tune.ltrcrsf}
\title{Tune \code{mtry} to the optimal value with respect to out-of-bag error for a LTRCRSF model}
\usage{
tune.ltrcrsf(
  formula,
  data,
  id,
  mtryStart = NULL,
  stepFactor = 2,
  time.eval = NULL,
  time.tau = NULL,
  ntreeTry = 100L,
  bootstrap = c("by.sub", "by.root", "by.node", "by.user", "none"),
  samptype = c("swor", "swr"),
  sampfrac = 0.632,
  samp = NULL,
  na.action = "na.omit",
  trace = TRUE,
  doBest = FALSE,
  plot = FALSE,
  ntime,
  nsplit = 10L,
  nodesizeTry = max(ceiling(sqrt(nrow(data))), 15),
  nodedepth = NULL
)
}
\arguments{
\item{formula}{a formula object, with the response being a \code{\link[survival]{Surv}}
object, with form


\code{Surv(tleft, tright, event)}.}

\item{data}{a a data frame containing \code{n} rows of
left-truncated right-censored observations.}

\item{id}{variable name of subject identifiers. If this is present, it will be
searched for in the \code{data} data frame. Each group of rows in \code{data}
with the same subject \code{id} represents the covariate path through time of
a single subject. If not specified, the algorithm then assumes \code{data}
contains left-truncated and right-censored survival data with time-invariant
covariates.}

\item{mtryStart}{starting value of \code{mtry}; default is \code{sqrt(nvar)}.}

\item{stepFactor}{at each iteration, \code{mtry} is inflated (or deflated)
by this value, used when \code{mtry} is not specified (see \code{\link{tune.ltrcrsf}}).
The default value is \code{2}.}

\item{time.eval}{a vector of time points, at which the estimated survival probabilities
are evaluated.}

\item{time.tau}{an optional vector, with the \emph{i}-th entry giving the upper time limit for the
computed survival probabilities for the \emph{i}-th data (i.e., only computes
survival probabilies at \code{time.eval[time.eval <= time.tau[i]]} for the \emph{i}-th
data of interest).}

\item{ntreeTry}{number of trees used at the tuning step.}

\item{bootstrap}{bootstrap protocol.
(1) If \code{id} is present,
the choices are: \code{"by.sub"} (by default) which bootstraps subjects,
\code{"by.root"} which bootstraps pseudo-subjects.
Both can be with or without replacement (by default sampling is without
replacement; see the option \code{samptype} below).
(2) If \code{id} is not specified, the default is \code{"by.root"} which
bootstraps the \code{data} by sampling with or without replacement;
if \code{"by.node"} is choosen, \code{data} is bootstrapped with replacement
at each node while growing the tree.
Regardless of the presence of \code{id}, if \code{"none"} is chosen, the
\code{data} is not bootstrapped at all. If \code{"by.user"} is choosen,
the bootstrap specified by \code{samp} is used.}

\item{samptype}{choices are \code{swor} (sampling without replacement) and
\code{swr} (sampling with replacement). The default action here is sampling
without replacement.}

\item{sampfrac}{a fraction, determining the proportion of subjects to draw
without replacement when \code{samptype = "swor"}. The default value is \code{0.632}.
To be more specific, if \code{id} is present, \code{0.632 * N} of subjects with their
pseudo-subject observations are drawn without replacement (\code{N} denotes the
number of subjects); otherwise, \code{0.632 * n} is the requested size
of the sample.}

\item{samp}{Bootstrap specification when \code{bootstype = "by.user"}.
Array of dim \code{n x ntree} specifying how many times each record appears
in each bootstrap sample.}

\item{na.action}{action taken if the data contains \code{NA}’s. The default
\code{"na.omit"} removes the entire record if any of its entries is
\code{NA} (for x-variables this applies only to those specifically listed
in \code{formula}). See function \code{\link[randomForestSRC]{rfsrc}} for
other available options.}

\item{trace}{whether to print the progress of the search. \code{trace = TRUE} is set by default.}

\item{doBest}{whether to run a \code{\link{ltrcrsf}} object using the optimal \code{mtry} found.
\code{doBest = FALSE} is set by default.}

\item{plot}{whether to plot the out-of-bag error as a function of \code{mtry}.
\code{plot = FALSE} is set by default.}

\item{ntime}{an integer value used for survival to constrain ensemble calculations
to a grid of \code{ntime} time points. Alternatively if a vector of values
of length greater than one is supplied, it is assumed these are the time points
to be used to constrain the calculations (note that the constrained time points
used will be the observed event times closest to the user supplied time points).
If no value is specified, the default action is to use all observed event times.}

\item{nsplit}{an non-negative integer value for number of random splits to consider
for each candidate splitting variable. This significantly increases speed.
When zero or \code{NULL}, the algorithm uses much slower deterministic splitting
where all possible splits are considered. \code{nsplit = 10L} by default.}

\item{nodesizeTry}{forest average terminal node size used at the tuning step.
It has been adjusted from the \code{\link[randomForestSRC]{rfsrc}} default
\code{15} for survival families.}

\item{nodedepth}{maximum depth to which a tree should be grown. The default behaviour
is that this parameter is ignored.}
}
\value{
If \code{doBest = FALSE} (default), this returns the optimal mtry value of those searched.

If \code{doBest = TRUE}, this returns the \code{\link{ltrcrsf}} object produced with the optimal \code{mtry}.
}
\description{
Starting with the default value of \code{mtry}, search for the optimal value
(with respect to out-of-bag error estimate) of \code{mtry} for \code{\link{ltrcrsf}}.
}
\examples{
### Example with data pbcsample
library(survival)
Formula = Surv(Start, Stop, Event) ~ age + alk.phos + ast + chol + edema
## mtry tuned by the OOB procedure with stepFactor 3, number of trees built 50.
mtryT = tune.ltrcrsf(formula = Formula, data = pbcsample, id = ID, stepFactor = 3,
                     ntreeTry = 20L, plot = TRUE)
}
\seealso{
\code{\link{sbrier_ltrc}} for evaluation of model fit for the optimal value of \code{mtry}.
}
