% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LST_MWA.R
\name{MWA}
\alias{MWA}
\title{Mono window algorithm}
\usage{
MWA(BT = BT, tau = tau, E = E, To = To)
}
\arguments{
\item{BT}{Raster* object, brightness temperature}

\item{tau}{Atmospheric transmittance}

\item{E}{Raster* object, NDVI calculated from remote sensing imagery}

\item{To}{Near-surface air temperature (°C) of the date when Landsat passed over the study area}
}
\value{
RasterLayer
}
\description{
This fumction calculates Land Surface Temperature using mono window algorithm
}
\examples{
BTemp <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(BTemp) = runif(10000, min=298, max=305)
E <- raster::raster(ncol=100, nrow=100)
set.seed(2)
raster::values(E) = runif(10000, min=0.96, max=0.99)
MWA(BT = BTemp, tau = 0.86, E = E, To = 26)
}
