% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cauchy_tests.R
\name{cauchy_scale_one_way}
\alias{cauchy_scale_one_way}
\title{Test equality of scales of cauchy distributions.}
\source{
\itemize{
\item \url{https://en.wikipedia.org/wiki/Likelihood-ratio_test}
\item Yudi Pawitan. In All Likelihood. Oxford University Press.
\item Hodd, McKean, and Craig. Introduction to Mathematical Statistics. Pearson.
}
}
\usage{
cauchy_scale_one_way(x, fctr, conf.level = 0.95)
}
\arguments{
\item{x}{a numeric vector of at least 50 data values per group.}

\item{fctr}{a factor vector indicating groups.}

\item{conf.level}{overall confidence level of the likelihood intervals. Uses Bonferroni correction.}
}
\value{
An S3 class containing the test statistic, p value, list of likelihood based confidence intervals,
overall confidence level, individual confidence level of each interval and alternative
hypothesis.
}
\description{
Test equality of scales of cauchy distributions.
}
\details{
\itemize{
\item Null: All scales are equal. (scale_1 = scale_2 ... scale_k).
\item Alternative: At least one scale is not equal.
}
}
\examples{
library(LRTesteR)

# Null is true
set.seed(1)
x <- rcauchy(n = 150, 1, 2)
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
cauchy_scale_one_way(x, fctr, .95)

# Null is false
set.seed(1)
x <- c(rcauchy(50, 2, 1), rcauchy(50, 2, 2), rcauchy(50, 2, 3))
fctr <- c(rep(1, 50), rep(2, 50), rep(3, 50))
fctr <- factor(fctr, levels = c("1", "2", "3"))
cauchy_scale_one_way(x, fctr, .95)
}
