% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_input.R
\name{locs_from_csv}
\alias{locs_from_csv}
\title{locs_from_csv}
\usage{
locs_from_csv(
  file = NULL,
  roi = NULL,
  channels = NULL,
  frame.filter = NULL,
  llrel.filter = NULL,
  locprec.filter = 0,
  locprecz.filter = 0
)
}
\arguments{
\item{file}{a csv file with columns x[nm], y[nm], z[nm] and optionally site[numbers], channel, locprec[nm] and locprecz[nm], other columns are ignored.}

\item{roi}{region of interest, keep points within the specified volume. Must be a data frame with columns x,y,z and rows min and max defining a bounding box.}

\item{channels}{vector of integers indicating which channel(s) of a multicolour experiment to get data from.}

\item{frame.filter}{vector of min and max values, filter out points from frames outside the specified range.}

\item{llrel.filter}{vector of min and max values, filter out points on log-likelihood (for fitted data).}

\item{locprec.filter}{filter out points with locprec value greater than the specified number. Points with locprec == 0 are also removed.}

\item{locprecz.filter}{filter out points with locprecz value greater than the specified number. Points with locprecz == 0 are also removed.}
}
\value{
a data frame with columns x,y,z, optionally site, locprec and locprecz.
}
\description{
Reads and filters single molecule localization events from a csv file as typically output by the SMAP software.
The main columns of interest are the coordinates (x, y, z), point set membership (site) and localization 
precision (locprec and locprecz).
}
\examples{
data.file <- system.file("test_data", "simulated_NUP107_data.csv", package = "LOMAR",
 mustWork = TRUE)
locs <- locs_from_csv(file = data.file, locprec.filter = 20)
}
