% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgno.R
\name{qgno}
\alias{qgno}
\title{Quantile distribution function of Generalized normal Distribution}
\usage{
qgno(u = NULL, RP = 1/(1 - u), para)
}
\arguments{
\item{u}{non-exceedance probability}

\item{RP}{Return Period "don't use in case u is used"}

\item{para}{parameters as c(location, scale, shape)}
}
\value{
Quantile value/s using the inverse of the cumulative distribution function.
}
\description{
Quantile distribution function of Generalized normal Distribution
}
\examples{

x <- qgno(u = 0.99, para = c(10, 0.1, 0.2))
x <- qgno(RP = 100, para = c(10, 0.1, 0.2))

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
