% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qgam.R
\name{qgam}
\alias{qgam}
\title{Quantile distribution function of Gamma distribution}
\usage{
qgam(u = NULL, RP = 1/(1 - u), para)
}
\arguments{
\item{u}{non-exceedance probability}

\item{RP}{Return Period "don't use in case u is used"}

\item{para}{parameters as c(shape, scale)}
}
\value{
Quantile value/s using the inverse of the cumulative distribution function.
}
\description{
Quantile distribution function of Gamma distribution
}
\examples{

x <- qgam(u = 0.99, para = c(0.1, 0.2))
x <- qgam(RP = 100, para = c(0.1, 0.2))

}
\author{
Mohanad Zaghloul [aut, cre], Simon Michael Papalexiou [aut, ths], Amin Elshorbagy [aut, ths]
}
