% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/structure.R
\name{UN}
\alias{UN}
\title{Unstructured Structure}
\usage{
UN(formula, var.cluster, var.time, add.time)
}
\arguments{
\item{formula}{formula indicating on which variable to stratify the covariance structure.}

\item{var.cluster}{[character] cluster variable.}

\item{var.time}{[character] time variable.}

\item{add.time}{Should the default formula (i.e. when \code{NULL}) contain a time effect.}
}
\value{
An object of class \code{UN} that can be passed to the argument \code{structure} of the \code{lmm} function.
}
\description{
Variance-covariance structure where the residuals have time-specific variance and correlation.
Can be stratified on a categorical variable.
}
\details{
A typical formula would be \code{~1}, indicating a time-specific variance parameter and a correlation parameter specific to each pair of times.
}
\examples{
UN(NULL, var.cluster = "id", var.time = "time", add.time = TRUE)
UN(~gender, var.cluster = "id", var.time = "time", add.time = TRUE)
UN(gender ~ 1, var.cluster = "id", var.time = "time", add.time = TRUE)
UN(list(~gender,~1), var.cluster = "id", var.time = "time", add.time = TRUE)
UN(list(gender~age,gender~1), var.cluster = "id", var.time = "time", add.time = TRUE)

}
\keyword{multivariate}
