% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_lmmelsm}
\alias{simulate_lmmelsm}
\title{Simulate data from latent uni/multidimensional MELSM}
\usage{
simulate_lmmelsm(
  n,
  K,
  lambda,
  resid,
  nu,
  mu_beta = NULL,
  logsd_beta = NULL,
  P_random_ind = NULL,
  Q_random_ind = NULL,
  mu_logsd_betas_cor,
  mu_logsd_betas_sigma,
  epsilon_cor,
  zeta = NULL,
  X_loc = NULL,
  X_sca = NULL,
  X_bet = NULL,
  L2_pred_only = FALSE
)
}
\arguments{
\item{n}{Integer. Number of repeated observations per group.}

\item{K}{Integer. Number of groups.}

\item{lambda}{Matrix (FxJ). Loading matrix.}

\item{resid}{Numeric vector (J). Residual SDs.}

\item{nu}{Numeric vector (J). Intercepts.}

\item{mu_beta}{Matrix (PxF). Location coefficient matrix.}

\item{logsd_beta}{Matrix (QxF). Scale coefficient matrix.}

\item{P_random_ind}{Integer vector (P_random). Which location predictors have random slopes.}

\item{Q_random_ind}{Integer vector (Q_random). Which scale predictors have random slopes.}

\item{mu_logsd_betas_cor}{Matrix (Symmetric, SPD; F\emph{2 + P_random}F + Q_random*F). Correlation matrix of random effects (slopes and intercepts, for location and scale models).}

\item{mu_logsd_betas_sigma}{Numeric vector (Positive; F\emph{2 + P_random}F + Q_random*F). RE SDs (intercepts on exponentiated scale, if zeta is specified).}

\item{epsilon_cor}{Matrix (Symmetric, SPD; F). Stochastic error term correlation between factors.}

\item{zeta}{Matrix (\code{Rx[F*2 + P_random*F + Q_random*F]}). Coefficient matrix for predicting RE SDs.}

\item{X_loc}{Matrix (Optional; NxP). Location design matrix.}

\item{X_sca}{Matrix (Optional; NxQ). Scale design matrix.}

\item{X_bet}{Matrix (Optional; NxR). Between-SD design matrix.}

\item{L2_pred_only}{Logical. Whether predictors should be group-level (TRUE) or observation level (FALSE).}
}
\value{
List of params (list), data (list), and df (data.frame).
}
\description{
Simulate data from latent uni/multidimensional MELSM
}
\author{
Stephen R. Martin
}
\keyword{internal}
