\name{plotLMER3d.fnc}
\alias{plotLMER3d.fnc}
\title{Dynamic 3d plot for \code{mer} object.}
\description{Plot dynamic 3d partial effects of a (generalized) linear mixed-effects model fit with \code{LMER}.}
\usage{plotLMER3d.fnc(model = NULL, pred, intr, plot.type = "contour",
xlim = range(x, na.rm = TRUE), ylim = range(y, na.rm = TRUE), 
zlim = range(z, na.rm = TRUE), xlab = NULL, 
ylab = NULL, zlab = NULL, main = NULL, cex = 1, fun = NA, n = 30, 
color = "topo", alpha = 1, alpha.rs = 0.65, alpha.u = 1, 
lit = TRUE, theta = 0, phi = 0, contourstepsize = 0.2, play3d = FALSE, 
ref.surf = FALSE, underneath = FALSE, add.raw = FALSE, color.raw = "grey", 
alpha.raw = 0.5, rug = FALSE, rug.u = FALSE, plot.dat = "default", 
path = "default")}
\arguments{
  \item{model}{A \code{mer} object or \code{NULL} (the default) to plot from an existing data-plotting object returned by this function and saved as an \code{.rda} file.}
  \item{pred}{The quoted name of a model predictor.}
  \item{intr}{The quoted name of a continuous model predicor.}
  \item{plot.type}{The type of plot to make. Can be any of \code{"contour"} (default), \code{"persp"}, or, if package \code{rgl} is available, \code{"persp3d"}.}
  \item{xlim, ylim, zlim}{\emph{x-}, \emph{y-} and \emph{z-}limits. The plot is produced so that the rectangular volume defined by these limits is visible.}
  \item{xlab, ylab, zlab}{Titles for the axes. N.B. These must be character strings; expressions are not accepted. Numbers will be coerced to character strings.}
  \item{main}{The main title on top of the plot.}
  \item{cex}{The size of label and main text.}
  \item{fun}{A function to be applied for transforming the dependent variable, if \code{NA}, no transformation is applied; for models with \code{family = "binomial"}, fun is set to \code{plogis} by default; this can be disabled by setting \code{fun=function(x)return(x)}.}
  \item{n}{Integer denoting number of points for the plot, chosen at equally spaced intervals across the empirical range of the predictor variable.}
  \item{color}{The colour scheme to use for plots. One of \code{topo}, \code{heat}, \code{cm}, \code{terrain}, \code{gray} or \code{bw}.  Schemes \code{gray}, \code{grey}, and \code{bw} also modify the colors used.}
  \item{alpha, alpha.rs, alpha.raw, alpha.u}{For \code{plot.type = "persp3d"}, alpha values between 0.0 (fully transparent) to 1.0 (opaque) for the main 3d surface, the reference surface, the added raw surface, and the "underneath" surface, respectively.}
  \item{lit}{Logical, specifying if lighting calculation should take place on geometry.}
  \item{theta}{Angle defining the viewing direction. \code{theta} gives the azimuthal direction. Used only if \code{plot.type = "persp"}.}
  \item{phi}{Angle defining the viewing direction. \code{phi} gives the colatitude. Used only if \code{plot.type = "persp"}.}
  \item{contourstepsize}{The size of the steps from contour line to contour line.}
  \item{play3d}{If \code{plot.type = "persp3d"} and \code{play3d} is set to \code{TRUE}, the 3d plot will spin around \code{axis} \code{c(0, 0, 1)} at \code{rpm} \code{4} for \code{duration} \code{20} seconds. The \code{axis}, \code{rpm}, and \code{duration} can be changed by supplying a three-argument list where the first argument is a three-element vector for the rotation axis, the second argument is an interger for the rotations per minute (rpm), and the the third argument is a rotation duration time.}
  \item{ref.surf}{If \code{plot.type = "persp3d"}, whether a reference surface at the mean ought to be plotted. Defaults to \code{FALSE}.}
  \item{underneath}{If \code{plot.type = "persp3d"}, whether a flat miror image of the 3d surface ought to be plotted underneath it. Defaults to \code{FALSE}.}
  \item{add.raw}{If \code{plot.type = "persp3d"}, whether to add a surface representing the raw data. Defaults to \code{FALSE}.}
  \item{color.raw}{The colour scheme to use for the raw data surface. One of \code{topo}, \code{heat}, \code{cm}, \code{terrain}, \code{gray} or \code{bw}.  Schemes \code{gray}, \code{grey}, and \code{bw} also modify the colors used.}
  \item{rug}{Whether a rug ought to be plotted on the 3d surface. Defaults to \code{FALSE}.}
  \item{rug.u}{For \code{plot.type = "persp3d"}, whether a rug ought to be plotted on the flat miror image of the 3d surface. Defaults to \code{FALSE}.}
  \item{plot.dat, path}{Whether to cache the plotting data generated by a previous call to \code{plotLMER3d.fnc}. Generating the 3d plots can be time consuming. If the \code{plot.dat} argument is non-FALSE, the plotting information generated in the first call to the function will be saved so that in a second call to the function with exactly the same argument values, the plotting information will be retrieved and plotting will be significantly quicker. If \code{plotting.data = "default"} and \code{path = "default"}, the plotting information will be saved in a a temporary directory and the name of the file containing the information will equal to \code{paste("lmer___",model@call,pred,intr,".rda",sep="")}. The name of the file and the path where it will be saved can be set by the user in the \code{plot.dat} and \code{path} arguments. For example, \code{plot.dat = "my_plotting.data", path = "Documents"}. Note that \code{"lmer___"} will be appended to the begining of whatever is specified in \code{plot.dat} and \code{".rda"} to the end. Also note that if the user wants to save the plotting information returned by this function, the name of this object has to be \code{z}.}
}
\details{See help page to Harald Baayen's \code{plotLMER.fnc} function as well as to Duncan Murdoch's \code{persp3d} function. To save screenshots of "persp3d" plots (after plotting), use function \code{rgl.snapshot} (produces \code{png} files) or function \code{rgl.postscript} (produces \code{eps} files).}
\author{Antoine Tremblay, IWK Health Center, \email{trea26@gmail.com}.} 
\value{Invisibly returns plotting information. If \code{plot.type = "contour"} or \code{plot.type = "persp"}, a contour or perspective plot, respectively. If \code{plot.type = "persp3d"}, a 2d plot as created by \code{plotLMER.fnc} as well as a dynamic 3d plot as created by \code{persp3d}. If \code{ret = TRUE}, a two-element list is returned containing the \emph{matrix} and the matrix of corresponding colors is returned. If argument \code{intel} in non-null, a file containing plotting information will be saved.}
\seealso{
\code{\link{persp}};
\code{\link{contour}};
}
\examples{
if("LCFdata"\%in\%.packages(all.available=TRUE)){
  library(LCFdata)
	library(lme4)
	data(eeg)
	eeg <- eeg[eeg$Time >= 100 & eeg$Time <= 175, , drop = TRUE]
	
	# fit initial model
	m1 = lmer(Fz ~ FreqB * LengthB * WMC + (1 | Subject) + 
	     (1 | Item), data = eeg)
	
	# trim data on initial model residuals
	eeg.trimmed = romr.fnc(m1, eeg, trim = 2.5)
	eeg = eeg.trimmed$data
	
	# update initial model on trimmed data
	mB = update(m1)
	
	# backfit fixed effects on F
	m2 = bfFixefLMER_t.fnc(mB, eeg, log.file = FALSE,
	     llrt = FALSE)
	pamer.fnc(m2)
	
	if("rgl" \%in\% .packages(all.available = TRUE)){
	library(rgl)
	open3d()
	plotLMER3d.fnc(m2, pred = "LengthB", intr = "WMC", 
	  plot.type = "persp3d",xlab = "LengthB", ylab = "WMC", 
	  zlab = "Amplitude",zlim = c(-9,2), add.raw = TRUE, 
	  cex = 0.75)
	}
	
	plotLMER3d.fnc(m2, pred = "LengthB", intr = "WMC", 
	  plot.type = "contour",xlab = "LengthB", ylab = "WMC", 
	  zlab = "Amplitude", contourstepsize = 0.2, cex = 0.75)
	
	plotLMER3d.fnc(m2, pred = "LengthB", intr = "WMC", 
	  plot.type = "persp",xlab = "LengthB", ylab = "WMC", 
	  zlab = "Amplitude", cex = 0.75, path = tempdir(),
		plot.dat = "my_plotting_info")
	
	plotLMER3d.fnc(m2, pred = "LengthB", intr = "WMC", 
	  plot.type = "persp",xlab = "LengthB", ylab = "WMC", 
	  zlab = "Amplitude", cex = 0.75, path = tempdir(),
		plot.dat = "my_plotting_info")
	
	devAskNewPage(ask=FALSE)
}
}
\keyword{hplot}
