% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AQSearch.R
\name{AQSearch}
\alias{AQSearch}
\alias{AQSearch.default}
\title{Search function for ATPS Systems data}
\usage{
AQSearch(db, ...)

\method{AQSearch}{default}(db = NULL, db.ph = NULL, db.upper = NULL,
  db.lower = NULL, db.temp = NULL, db.additive = NULL,
  subset = FALSE, ...)
}
\arguments{
\item{db}{A list of three data.frame variables within all systems data are stored.}

\item{...}{Additional optional arguments. None are used at present.}

\item{db.ph}{A numeric variable containing the pH to be searched within DB.}

\item{db.upper}{A String variable containing the CAS of the lower's phase component to be searched within DB.}

\item{db.lower}{A String variable containing the CAS of the lower's phase component to be searched within DB.}

\item{db.temp}{A numeric variable containing the Temperature (in Kelvin) to be searched within DB.}

\item{db.additive}{A String variable containing the CAS of the additive component to be searched within DB.}

\item{subset}{If FALSE, the function returns the index of the systems that matches the search. If TRUE, the function returns a subset with all system data.}
}
\value{
System's index (when subset = FALSE) or system's parameters (subset = TRUE)
}
\description{
This function allow the user to search the LLSR database to find any ATPS that matches the used criteria.

This function allow the user to search the package database to find any ATPS that matches the used criteria.
}
\details{
The function return the systems that matches the criteria submit by the user. Beware that using it with subset = FALSE will return the system's entry reference as a MD5 encoded string.
}
\examples{
\dontrun{
AQSearch(db,db.upper="85100-78-3", subset = TRUE)
}
}
