% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{LDL_DensityPlotOfbootst}
\alias{LDL_DensityPlotOfbootst}
\title{Plot density of bootstrap and empirical variance for LDL}
\usage{
LDL_DensityPlotOfbootst(DF, title = "", empirVrnc, errPropVrnc)
}
\arguments{
\item{DF}{The data frame containing the bootstrap variances of LDL.}

\item{title}{Title of the plot (default="")}

\item{empirVrnc}{The value of of the empirical (experimental) variance.}

\item{errPropVrnc}{The value of the error propagation variance.}
}
\value{
Plots the respective plot.
}
\description{
Plot density of the bootstrap variance for LDL along with the median,
2.5 and 97.5 percentile as vertical lines.
Also plots the empirical variance as a segment from the bottom to the middle
of the graph and the error propagation variance as a line segment from the
top to the middle of the graph. DF must the dataframe of the list
returned from the respective Bootstrap variance function.
}
\examples{
\dontrun{
LDL_empirVrnc = var(sampleA$LDL)
LDL_errPropVrnc = LDLErrPrp(sampleA$CHOL,sampleA$HDL,sampleA$TG)
LDLbootStrp=as.data.frame(LDLbootVrnc(sampleA$CHOL,sampleA$HDL,sampleA$TG))
LDL_DensityPlotOfbootst(LDLbootStrp,"Title",LDL_empirVrnc,LDL_errPropVrnc)
}
}
