% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AIPerrorVariance.R
\name{AIP_HDLVrnc}
\alias{AIP_HDLVrnc}
\title{Calculate the variance of AIP when HDL changes.}
\usage{
AIP_HDLVrnc(dfHDL, TG, SI = TRUE, bootStrpReps = 2000)
}
\arguments{
\item{dfHDL}{A data frame where each column contains a different set of HDL
values of increasing variance as the column index increases.}

\item{TG}{A vector or data frame column containing the triglyceride (TG)
values to be used for the calculation of the variance of the
Atherogenic Index of Plasma (AIP).}

\item{SI}{Boolean (default=TRUE). AIP is by definition calculated using SI
units for TG and HDL (mmol/L). If mg/dl units are provided instead, SI must
be set to FALSE.}

\item{bootStrpReps}{(Default=2000) Number of bootstrap iterations
for bootstrap variance calculation.}
}
\value{
It returns a list with the first order Error Propagation variance
(ErrPropVrnc), the second order Error Propagation variance (ErrPropVrnc2Ord)
and the bootstrap variance (BootVrnc). Each list element is a vector of
length equal to the number of columns of the HDL data frame supplied as
argument (dfHDL) and each vector value corresponds to the respective
variance of the corresponding data frame columns.
}
\description{
This function calculates the variance of the Atherogenic Index of Plasma
(AIP) using two methods:
Error Propagation (first and second order) and Bootstrap when the HDL
distribution changes. It uses a
data frame where each column contains a different set of HDL values of
increasing variance as the column index increases.
}
\examples{
\dontrun{
dfHDL = CV_Range(sampleB$HDL,0,100,maxRandIter = 1000, plot=FALSE)
AIP_HDLVrnc=AIP_HDLVrnc(dfHDL,sampleA$TG, bootStrpReps=2000)
}
}
