% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LAGOSNE-package.R
\docType{data}
\name{lagoslakes}
\alias{lagoslakes}
\alias{lakes.geo}
\title{Lake Geospatial Metadata}
\format{
A data frame with 141271 observations and 31 variables:
\itemize{
             \item lagoslakeid: unique lake identifier in LAGOSNE
             \item lakes_nhdid: unique lake identifier from the National
             Hydrography Dataset (NHD)
             \item iws_zoneid: zone ID of interlake watershed (IWS) in which
             focal lake is located
             \item hu4_zoneid: zone ID of HUC4 in which focal lake is
             located
             \item hu6_zoneid: zone ID of HUC6 in which focal lake is
             located
             \item hu8_zoneid: zone ID of HUC8 in which focal lake is
             located
             \item hu12_zoneid: zone ID of HU12 in which focal lake is
             located
             \item edu_zoneid: zone ID of ecological drainage unit (EDU) in
             which focal lake is located
             \item county_zoneid: zone ID of county in which focal lake is
             located
             \item state_zoneid: two-letter abbreviation of state in which
             focal lake is located
             \item upstream_lakes_4ha_count: count of lakes >= 4 ha upstream of the focal lake,
             connected via the NHD network of all surface flow connections
             (defined as ephemeral, intermittent, or permanent streams, or any other connections)
             \item upstream_lakes_4ha_area_ha: total area of lakes >= 4 ha upstream of the focal lake,
             connected via the NHD network of all surface flow connections
             (defined as ephemeral, intermittent, or permanent streams, or any other connections)
             \item upstream_lakes_10ha_count: count of lakes >= 10 ha upstream of the focal lake,
             connected via the NHD network of all surface flow connections
             (defined as ephemeral, intermittent, or permanent streams, or any other connections)
             \item upstream_lakes_10ha_area_ha: total area of lakes >= 10ha upstream of the focal lake,
             connected via the NHD network of all surface flow connections
             (defined as ephemeral, intermittent, or permanent streams, or any other connections)
             \item latewisconsinglaciation_glacial: glaciation status during the Late Wisconsin glaciation,
             where 'Glaciated' where the whole zone was glaciated, 'Not_Glaciated' where the whole zone
             was not glaciated, and 'Partially_Glaciated' where a part of the zone was glaciated
             \item wlconnections_allwetlands_*: the wetland polygons that intersect or are
             within 30 m buffer around a lake shoreline, measured as count, area (ha), or sum of
             shoreline length (km) that intersects or touches wetland polygons
             (* = count, contributing_area_ha, shoreline_km).
             \item wlconnections_forestedwetlands_count: the forested wetland polygons that intersect or are
             within 30 m buffer around a lake shoreline, measured as count, area (ha), or sum of
             shoreline length (km) that intersects or touches wetland polygons
             (* = count, contributing_area_ha, shoreline_km).
             \item wlconnections_scrubshrubwetlands_count: the scrub-shrub wetland polygons that intersect or are
             within 30 m buffer around a lake shoreline, measured as count, area (ha), or sum of
             shoreline length (km) that intersects or touches wetland polygons
             (* = count, contributing_area_ha, shoreline_km).
             \item wlconnections_openwaterwetlands_count: the open water wetland polygons that intersect or are
             within 30 m buffer around a lake shoreline, measured as count, area (ha), or sum of
             shoreline length (km) that intersects or touches wetland polygons
             (* = count, contributing_area_ha, shoreline_km).
             \item wlconnections_otherwetlands_count: the other-wetland polygons that intersect or are
             within 30 m buffer around a lake shoreline, measured as count, area (ha), or sum of
             shoreline length (km) that intersects or touches wetland polygons
             (* = count, contributing_area_ha, shoreline_km).
             \item lakeconnection: connectivity of focal lake to upstream
             features (DR_LakeStream = drainage lake with an upstream lake,
             DR_Stream = drainage lake with upstream stream,
             Headwater = lake with outlet but no inlet,
             Isolated = lake with no inlets or outlets)
    }
}
\description{
A dataset containing geospatial identifiers, upstream lake connectivity, and
wetland connectivity of all lakes in LAGOSNE >1 hectare.
}
\references{
Soranno et al. (2017) \href{https://doi.org/10.1093/gigascience/gix101}{Gigascience 6:12}
}
\keyword{datasets}
