% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L1cent.R
\name{Lorenz_plot}
\alias{Lorenz_plot}
\title{Lorenz Curve and the Gini Coefficient}
\usage{
Lorenz_plot(x, add = FALSE, ...)
}
\arguments{
\item{x}{A numeric vector.}

\item{add}{A logical value.
\itemize{
\item \code{TRUE}: add the Lorenz curve to an already existing plot.
\item \code{FALSE} (the default): draw the Lorenz curve to a new graphic device.
}}

\item{...}{Further graphical parameters supplied to the internal
\code{\link[base:plot]{base::plot()}} (when \code{add = FALSE}) or \code{\link[graphics:lines]{graphics::lines()}} (when
\code{add = TRUE}) function. See \code{\link[graphics:par]{graphics::par()}} document.}
}
\value{
Draws a Lorenz curve (the group heterogeneity plot) and returns an
invisible copy of a Gini coefficient (the group heterogeneity index).
}
\description{
Draws a Lorenz curve (the group heterogeneity plot) and computes the Gini
coefficient (the group heterogeneity index).
}
\examples{
vertex_weight <- igraph::V(MCUmovie)$worldwidegross
cent <- L1cent(MCUmovie, eta=vertex_weight)
gini <- Lorenz_plot(cent, asp=1)
graphics::abline(0,1,lty=2)
# group heterogeneity index
gini
}
\references{
S. Kang and H.-S. Oh. On a notion of graph centrality based on
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} data depth.
\emph{arXiv preprint arXiv:2404.13233}, 2024.

M. O. Lorenz. Methods of measuring the concentration of wealth.
\emph{Publications of the American Statistical Association}, 9(70):209--219, 1905.
}
\seealso{
Use the function with \code{\link[=L1cent]{L1cent()}} or \code{\link[=L1centLOC]{L1centLOC()}}, and compare
distributions of the centrality measurements across several groups and
graphs.
}
