% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.L0Learn}
\alias{predict.L0Learn}
\alias{predict.L0LearnCV}
\title{Predict Response}
\usage{
\method{predict}{L0Learn}(object, newx, lambda = NULL, gamma = NULL,
  ...)

\method{predict}{L0LearnCV}(object, newx, lambda = NULL, gamma = NULL,
  ...)
}
\arguments{
\item{object}{The output of L0Learn.fit or L0Learn.cvfit}

\item{newx}{A matrix on which predictions are made. The matrix should have p columns.}

\item{lambda}{The value of lambda to use for prediction. A summary of the lambdas in the regularization
path can be obtained using \code{print(fit)}.}

\item{gamma}{The value of gamma to use for prediction. A summary of the gammas in the regularization
path can be obtained using \code{print(fit)}.}

\item{...}{ignore}
}
\description{
Predicts the response for a given sample.
}
\details{
If both lambda and gamma are not supplied, then a matrix of predictions
for all the solutions in the regularization path is returned. If lambda is
supplied but gamma is not, the smallest value of gamma is used. In case of
of logistic regression, probability values are returned.
}
\examples{
# Generate synthetic data for this example
data <- GenSynthetic(n=500,p=1000,k=10,seed=1)
X = data$X
y = data$y

# Fit an L0L2 Model with 10 values of Gamma ranging from 0.0001 to 10, using coordinate descent
fit <- L0Learn.fit(X,y, penalty="L0L2", maxSuppSize=50, nGamma=10, gammaMin=0.0001, gammaMax = 10)
print(fit)
# Apply the fitted model with lambda=0.0361829 and gamma=0.0001 on X to predict the response
predict(fit, newx = X, lambda=0.0361829, gamma=0.0001)
# Apply the fitted model on X to predict the response for all the solutions in the path
predict(fit, newx = X)

}
