% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MdeFunc31.R
\name{KoulLrMde}
\alias{KoulLrMde}
\title{Minimum distance estimation in linear regression model.}
\usage{
KoulLrMde(Y, X, D, b0, IntMeasure, TuningConst = 1.345)
}
\arguments{
\item{Y}{- Vector of response variables in linear regression model.}

\item{X}{- Design matrix of explanatory variables in linear regression model.}

\item{D}{- Weight Matrix. Dimension of D should match that of X. Default value is XA where A=(X'X)^(-1/2).}

\item{b0}{- Initial value for beta.}

\item{IntMeasure}{- Symmetric and \eqn{\sigma}-finite measure: Lebesgue, Degenerate, and Robust}

\item{TuningConst}{- Used only for Robust measure.}
}
\value{
betahat    - Minimum distance estimator of \eqn{\beta}.

residual   - Residuals after minimum distance estimation.

ObjVal     - Value of the objective function at minimum distance estimator.
}
\description{
Estimates the regression coefficients in the model \eqn{Y=X\beta + \epsilon}.
}
\examples{
####################
n <- 10
p <- 3
X <- matrix(runif(n*p, 0,50), nrow=n, ncol=p)  #### Generate n-by-p design matrix X
beta <- c(-2, 0.3, 1.5)                        #### Generate true beta = (-2, 0.3, 1.5)'
eps <- rnorm(n, 0,1)                           #### Generate errors from N(0,1)
Y <- X\%*\%beta + eps

D <- "default"                                 #### Use the default weight matrix
b0 <- solve(t(X)\%*\%X)\%*\%(t(X)\%*\%Y)             #### Set initial value for beta
IntMeasure <- "Lebesgue"                       ##### Define Lebesgue measure


MDEResult <- KoulLrMde(Y,X,D, b0, IntMeasure, TuningConst=1.345)

betahat <- MDEResult$betahat                   ##### Obtain minimum distance estimator
resid <- MDEResult$residual                    ##### Obtain residual
objVal <- MDEResult$ObjVal                     ##### Obtain the value of the objective function


IntMeasure <- "Degenerate"                     ##### Define degenerate measure at 0

MDEResult <- KoulLrMde(Y,X,D, b0, IntMeasure, TuningConst=1.345)
betahat <- MDEResult$betahat                   ##### Obtain minimum distance estimator
resid <- MDEResult$residual                    ##### Obtain residual
objVal <- MDEResult$ObjVal                     ##### Obtain the value of the objective function



IntMeasure <- "Robust"                        ##### Define "Robust" measure
TuningConst <- 3                              ##### Define the tuning constant
MDEResult <- KoulLrMde(Y,X,D, b0, IntMeasure, TuningConst)


betahat <- MDEResult$betahat                   ##### Obtain minimum distance estimator
resid <- MDEResult$residual                    ##### Obtain residual
objVal <- MDEResult$ObjVal                     ##### Obtain the value of the objective function
}
\references{
[1] Kim, J. (2018). A fast algorithm for the coordinate-wise minimum distance estimation. J. Stat. Comput. Simul., 3: 482 - 497

[2] Kim, J. (2020). Minimum distance estimation in linear regression model with strong mixing errors. Commun. Stat. - Theory Methods., 49(6): 1475 - 1494

[3] Koul, H. L (1985). Minimum distance estimation in linear regression with unknown error distributions. Statist. Probab. Lett., 3: 1-8.

[4] Koul, H. L (1986). Minimum distance estimation and goodness-of-fit tests in first-order autoregression. Ann. Statist., 14 1194-1213.

[5] Koul, H. L (2002). Weighted empirical process in nonlinear dynamic models. Springer, Berlin, Vol. 166
}
\seealso{
KoulArMde() and Koul2StageMde()
}
