/*
 * Decompiled with CFR 0.152.
 */
package kr.pe.freesearch.jhannanum.comm;

import java.io.IOException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.LinkedList;
import kr.ac.kaist.swrc.jhannanum.comm.Eojeol;
import kr.ac.kaist.swrc.jhannanum.comm.Sentence;
import kr.ac.kaist.swrc.jhannanum.hannanum.Workflow;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.KoNLPChartMorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.MorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.PosTagger.HmmPosTagger.KoNLPHMMTagger;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.PosTagger.PosTagger;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.MorphemeProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.UnknownMorphProcessor.UnknownProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.InformalSentenceFilter.InformalSentenceFilter;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.PlainTextProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.SentenceSegmentor2.SentenceSegmentor2;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.Spacing;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.NounExtractor.NounExtractor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.PosProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.SimplePOSResult09.SimplePOSResult09;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.SimplePOSResult22.SimplePOSResult22;

public class HannanumInterface {
    private static Workflow wf = null;

    public void reloadAllDic() {
        if (wf != null) {
            wf.clear();
            wf = null;
        }
        System.gc();
    }

    public int reloadUserDic(String dicPath, String work) throws IOException {
        if (work.equals("extractNoun")) {
            if (wf != null) {
                wf.reloadUserDic(dicPath);
                return 0;
            }
            return -1;
        }
        if (work.equals("SimplePos09")) {
            if (wf != null) {
                wf.reloadUserDic(dicPath);
                return 0;
            }
            return -1;
        }
        if (work.equals("SimplePos22")) {
            if (wf != null) {
                wf.reloadUserDic(dicPath);
                return 0;
            }
            return -1;
        }
        if (work.equals("MorphAnalyzer")) {
            if (wf != null) {
                wf.reloadUserDic(dicPath);
                return 0;
            }
            return -1;
        }
        return -2;
    }

    public void reloadUserDic(String dicPath) throws IOException {
        if (wf != null) {
            wf.reloadUserDic(dicPath);
        }
        System.gc();
    }

    public String[] extractNoun(String basedir, String sentence, String userDicFile, boolean isSpacing) {
        String ctx = "extractNoun";
        if (isSpacing) {
            ctx = String.valueOf(ctx) + "_sp";
        }
        if (wf != null && !wf.getCtx().equals(ctx)) {
            wf.clear();
            wf = null;
        }
        if (wf == null) {
            wf = new Workflow(basedir, ctx);
            wf.appendPlainTextProcessor((PlainTextProcessor)new SentenceSegmentor2(), null);
            if (ctx.equals("extractNoun_sp")) {
                wf.appendPlainTextProcessor((PlainTextProcessor)new Spacing(), "");
            }
            wf.appendPlainTextProcessor((PlainTextProcessor)new InformalSentenceFilter(), null);
            wf.setMorphAnalyzer((MorphAnalyzer)new KoNLPChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
            wf.setMorphUserDic(userDicFile);
            wf.appendMorphemeProcessor((MorphemeProcessor)new UnknownProcessor(), null);
            wf.setPosTagger((PosTagger)new KoNLPHMMTagger(), "conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json");
            wf.appendPosProcessor((PosProcessor)new NounExtractor(), null);
            try {
                wf.activateWorkflow(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                wf.close();
                wf = null;
                return null;
            }
        }
        ArrayList<String> list = null;
        try {
            String n_sentence = Normalizer.normalize(sentence, Normalizer.Form.NFKC);
            wf.analyze(n_sentence);
            LinkedList resultList = wf.getResultOfDocument((Object)new Sentence(0, 0, false));
            list = new ArrayList<String>();
            for (Sentence s : resultList) {
                Eojeol[] eojeolArray = s.getEojeols();
                int i = 0;
                while (i < eojeolArray.length) {
                    if (eojeolArray[i].length > 0) {
                        String[] morphemes = eojeolArray[i].getMorphemes();
                        int j = 0;
                        while (j < morphemes.length) {
                            list.add(morphemes[j]);
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            wf.close();
            return null;
        }
        wf.close();
        return list.toArray(new String[0]);
    }

    public String MorphAnalyzer(String basedir, String sentence, String userDicFile, boolean isSpacing) {
        String ctx = "MorphAnalyzer";
        if (isSpacing) {
            ctx = String.valueOf(ctx) + "_sp";
        }
        if (wf != null && !wf.getCtx().equals(ctx)) {
            wf.clear();
            wf = null;
        }
        if (wf == null) {
            wf = new Workflow(basedir, ctx);
            wf.appendPlainTextProcessor((PlainTextProcessor)new SentenceSegmentor2(), null);
            if (ctx.equals("MorphAnalyzer_sp")) {
                wf.appendPlainTextProcessor((PlainTextProcessor)new Spacing(), "");
            }
            wf.appendPlainTextProcessor((PlainTextProcessor)new InformalSentenceFilter(), null);
            wf.setMorphAnalyzer((MorphAnalyzer)new KoNLPChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
            wf.setMorphUserDic(userDicFile);
            wf.appendMorphemeProcessor((MorphemeProcessor)new UnknownProcessor(), null);
            try {
                wf.activateWorkflow(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                wf.close();
                wf = null;
                return null;
            }
        }
        String morphs = null;
        try {
            String n_sentence = Normalizer.normalize(sentence, Normalizer.Form.NFKC);
            wf.analyze(n_sentence);
            morphs = wf.getResultOfDocument();
            wf.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            wf.close();
            return null;
        }
        wf.close();
        return morphs;
    }

    public String SimplePos22(String basedir, String sentence, String userDicFile, boolean isSpacing) {
        String ctx = "SimplePos22";
        if (isSpacing) {
            ctx = String.valueOf(ctx) + "_sp";
        }
        if (wf != null && !wf.getCtx().equals(ctx)) {
            wf.clear();
            wf = null;
        }
        if (wf == null) {
            wf = new Workflow(basedir, ctx);
            wf.appendPlainTextProcessor((PlainTextProcessor)new SentenceSegmentor2(), null);
            if (ctx.equals("SimplePos22_sp")) {
                wf.appendPlainTextProcessor((PlainTextProcessor)new Spacing(), "");
            }
            wf.appendPlainTextProcessor((PlainTextProcessor)new InformalSentenceFilter(), null);
            wf.setMorphAnalyzer((MorphAnalyzer)new KoNLPChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
            wf.setMorphUserDic(userDicFile);
            wf.appendMorphemeProcessor((MorphemeProcessor)new UnknownProcessor(), null);
            wf.setPosTagger((PosTagger)new KoNLPHMMTagger(), "conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json");
            wf.appendPosProcessor((PosProcessor)new SimplePOSResult22(), null);
            try {
                wf.activateWorkflow(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                wf.close();
                wf = null;
                return null;
            }
        }
        String morphs = null;
        try {
            String n_sentence = Normalizer.normalize(sentence, Normalizer.Form.NFKC);
            wf.analyze(n_sentence);
            morphs = wf.getResultOfDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            wf.close();
            return null;
        }
        wf.close();
        return morphs;
    }

    public String SimplePos09(String basedir, String sentence, String userDicFile, boolean isSpacing) {
        String ctx = "SimplePos09";
        if (isSpacing) {
            ctx = String.valueOf(ctx) + "_sp";
        }
        if (wf != null && !wf.getCtx().equals(ctx)) {
            wf.clear();
            wf = null;
        }
        if (wf == null) {
            wf = new Workflow(basedir, ctx);
            wf.appendPlainTextProcessor((PlainTextProcessor)new SentenceSegmentor2(), null);
            if (ctx.equals("SimplePos09_sp")) {
                wf.appendPlainTextProcessor((PlainTextProcessor)new Spacing(), "");
            }
            wf.appendPlainTextProcessor((PlainTextProcessor)new InformalSentenceFilter(), null);
            wf.setMorphAnalyzer((MorphAnalyzer)new KoNLPChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
            wf.setMorphUserDic(userDicFile);
            wf.appendMorphemeProcessor((MorphemeProcessor)new UnknownProcessor(), null);
            wf.setPosTagger((PosTagger)new KoNLPHMMTagger(), "conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json");
            wf.appendPosProcessor((PosProcessor)new SimplePOSResult09(), null);
            try {
                wf.activateWorkflow(false);
            }
            catch (Exception e) {
                e.printStackTrace();
                wf.close();
                wf = null;
                return null;
            }
        }
        String morphs = null;
        try {
            String n_sentence = Normalizer.normalize(sentence, Normalizer.Form.NFKC);
            wf.analyze(n_sentence);
            morphs = wf.getResultOfDocument();
        }
        catch (Exception e) {
            e.printStackTrace();
            wf.close();
            return null;
        }
        wf.close();
        return morphs;
    }

    public static void main(String[] args) throws IOException {
        HannanumInterface hi = new HannanumInterface();
        String[] ret1 = hi.extractNoun("C:/R/R-3.3.2/library/Sejong/dics/handic.zip", "\uacf5\ubcf4\uad00\ud1b5\uc0c1\uc9c4\ud765\uad6d\uc7a5\uc804\uc790\uacf5\uc5c5\uad6d\uc7a5\ubb34\uc5ed\uc870\uc0ac\uc2e4\uc7a5\uc81c 1\ucc28\uad00\ubcf4.", "C:/R/R-3.3.2/library/KoNLP/../KoNLP_dic/current/dic_user.txt", true);
        int i1 = 0;
        while (i1 < ret1.length) {
            System.out.println(ret1[i1]);
            ++i1;
        }
        String[] ret2 = hi.extractNoun("C:/R/R-3.3.2/library/Sejong/dics/handic.zip", "\uc778\ud130\ub137 \uc18c\uc124\uc774", "C:/R/R-3.3.2/library/KoNLP/../KoNLP_dic/current/dic_user.txt", true);
        int i12 = 0;
        while (i12 < ret2.length) {
            System.out.println(ret2[i12]);
            ++i12;
        }
    }
}

