/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.WordlistLoader;
import org.apache.lucene.analysis.kr.KoreanFilter;
import org.apache.lucene.analysis.kr.KoreanTokenizer;

public class KoreanAnalyzer
extends Analyzer {
    private Set stopSet;
    private boolean bigrammable = true;
    private boolean hasOrigin = true;
    public static final String[] STOP_WORDS = new String[]{"a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with"};
    public static final String[] KOR_STOP_WORDS = new String[]{"\uc774", "\uadf8", "\uc800", "\uac83", "\uc218", "\ub4f1", "\ub4e4"};
    public static final String DIC_ENCODING = "UTF-8";
    public static final int DEFAULT_MAX_TOKEN_LENGTH = 255;

    public KoreanAnalyzer() {
        this(STOP_WORDS);
    }

    public KoreanAnalyzer(String[] stopWords) {
        this.stopSet = StopFilter.makeStopSet((String[])stopWords);
        this.stopSet.addAll(StopFilter.makeStopSet((String[])KOR_STOP_WORDS));
    }

    public KoreanAnalyzer(File stopwords) throws IOException {
        FileInputStream is = new FileInputStream(stopwords);
        InputStreamReader reader = new InputStreamReader((InputStream)is, DIC_ENCODING);
        this.stopSet = WordlistLoader.getWordSet((Reader)reader);
    }

    public KoreanAnalyzer(File stopwords, String encoding) throws IOException {
        FileInputStream is = new FileInputStream(stopwords);
        InputStreamReader reader = new InputStreamReader((InputStream)is, encoding);
        this.stopSet = WordlistLoader.getWordSet((Reader)reader);
    }

    public KoreanAnalyzer(Reader stopwords) throws IOException {
        this.stopSet = WordlistLoader.getWordSet((Reader)stopwords);
    }

    public TokenStream tokenStream(String fieldName, Reader reader) {
        KoreanTokenizer tokenStream = new KoreanTokenizer(reader);
        KoreanFilter result = new KoreanFilter((TokenStream)tokenStream, this.bigrammable, this.hasOrigin);
        result = new LowerCaseFilter((TokenStream)result);
        result = new StopFilter((TokenStream)result, this.stopSet);
        return result;
    }

    public void setBigrammable(boolean is) {
        this.bigrammable = is;
    }

    public void setHasOrigin(boolean has) {
        this.hasOrigin = has;
    }
}

