% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernelFunctions.R
\name{kernel.function}
\alias{kernel.function}
\alias{kernel.gaussian}
\alias{kernel.linear}
\alias{kernel.polynomial}
\alias{kernel.sigmoid}
\alias{kernel.inverse.quadratic}
\alias{kernel.equality}
\title{Kernel Functions}
\usage{
kernel.gaussian(x, rho = ncol(x))

kernel.linear(x)

kernel.polynomial(x, rho = 1, gamma = 0, d = 1)

kernel.sigmoid(x, rho = 1, gamma = 1)

kernel.inverse.quadratic(x, gamma = 1)

kernel.equality(x)
}
\arguments{
\item{x}{a \eqn{n \times p}{n x p} matrix}

\item{gamma, rho, d}{kernel hyperparameters (see details)}
}
\value{
A \eqn{n \times n}{n x n} matrix.
}
\description{
These functions transform a \eqn{n \times p}{n x p} matrix into a \eqn{n \times n}{n x n} kernel matrix.
}
\details{
Given two \eqn{p-}dimensional vectors \eqn{x} and \eqn{y},
\itemize{
\item the Gaussian kernel is defined as \eqn{k(x,y) = exp\left(-\frac{\parallel x-y \parallel^2}{\rho}\right)}{k(x,y) = exp(-||x-y||^2 / rho)} where \eqn{\parallel x-y \parallel}{||x-y||} is the Euclidean distance between \eqn{x} and \eqn{y} and \eqn{\rho > 0}{rho > 0} is the bandwidth of the kernel,
\item the linear kernel is defined as \eqn{k(x,y) = x^Ty}{k(x,y) = t(x).y},
\item the polynomial kernel is defined as \eqn{k(x,y) = (\rho x^Ty + \gamma)^d}{k(x,y) = (rho.t(x).y + gamma)^d} with \eqn{\rho > 0}{rho > 0}, \eqn{d} is the polynomial order. Of note, a linear kernel is a polynomial kernel with \eqn{\rho = d = 1}{rho = d = 1} and \eqn{\gamma = 0}{gamma = 0},
\item the sigmoid kernel is defined as \eqn{k(x,y) = tanh(\rho x^Ty + \gamma)}{k(x,y) = tanh(rho.t(x).y + gamma)} which is similar to the sigmoid function in logistic regression,
\item the inverse quadratic function defined as \eqn{k(x,y) = \frac{1}{\sqrt{\parallel x-y \parallel^2 + \gamma}}}{k(x,y) = 1 / sqrt( ||x-y||^2 + gamma)} with \eqn{\gamma > 0}{gamma > 0},
\item the equality kernel defined as \eqn{k(x,y) = \left\lbrace \begin{array}{ll} 1 & if  x = y \\ 0 & otherwise \end{array}\right.}{k(x,y) = 1 if x = y, 0 otherwise}.
}
Of note, Gaussian, inverse quadratic and equality kernels are measures of similarity resulting to a matrix containing 1 along the diagonal.
}
\references{
Liu, D., Lin, X., and Ghosh, D. (2007). Semiparametric regression of multidimensional genetic pathway data: least squares kernel machines and linear mixed models. Biometrics, 63(4), 1079:1088.
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
