% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepCoxKM.R
\name{prepCoxKM}
\alias{prepCoxKM}
\title{KM for Survival Traits in GWAS Data (fit null model)}
\usage{
prepCoxKM(
  Z,
  formula,
  SNPInfo = NULL,
  snpNames = "Name",
  aggregateBy = "gene",
  data = parent.frame(),
  verbose = FALSE
)
}
\arguments{
\item{Z}{A matrix of genotypes (class: matrix).  rows correspond to individuals and columns correspond to SNPs. Use ’NA’ for missing values. The column names of this matrix should correspond to SNP names in the SNP information file.}

\item{formula}{Base formula under null hypothesis (class: formula). For Cox models, the formula follows that of the coxph() function.}

\item{SNPInfo}{SNP Info file (class: data.frame). Must contain fields given in ’snpName’ and ’aggregateBy’.}

\item{snpNames}{The field of SNPInfo where the SNP identifiers are found. (Default="Name")}

\item{aggregateBy}{The field of SNPInfo on which the skat results were aggregated. (Default="gene")}

\item{data}{The data file in which to find variables in the formula (class: data.frame).}

\item{verbose}{Whether or not to print the progress bar (class: logical).}
}
\value{
output: object as input for FbKM
}
\description{
This function (CoxKM) is used to perform KM analysis (Chen et al., 2014) for survival traits in GWAS data \cr
}
