% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkModel.R
\name{is.SSModel}
\alias{is.SSModel}
\title{Test whether object is a valid \code{SSModel} object}
\usage{
is.SSModel(object, na.check = FALSE, return.logical = TRUE)
}
\arguments{
\item{object}{An object to be tested.}

\item{na.check}{Test the system matrices for \code{NA} and infinite values.
Also checks for large values (> 1e7) in covariance matrices \code{H}
and \code{Q} which could cause large rounding errors in filtering.
Positive semidefiniteness of these matrices is not checked. Default
  is \code{FALSE}.}

\item{return.logical}{If \code{FALSE} (default), an error is given if the the model is not
a valid \code{SSModel} object. Otherwise logical value is returned.}
}
\value{
Logical value or nothing, depending on the value of
  \code{return.logical}.
}
\description{
Function \code{is.SSModel} tests whether the object is a valid \code{SSModel}
object.
}
\details{
Note that the validity of the values in \code{y} and \code{Z} are not tested.
These can contain NA values (but not infinite values),  with condition that
when \code{Z[i,,t]} contains NA value, the corresponding \code{y[t,i]} must
also have NA value. In this case \code{Z[i,,t]} is not referenced in
filtering and smoothing, and algorithms works properly.
}
\examples{
model <- SSModel(rnorm(10) ~ 1)
is.SSModel(model)
model['H'] <- 1
is.SSModel(model)
model$H[] <- 1
is.SSModel(model)
model$H[,,1] <- 1
is.SSModel(model)
model$H <- 1
is.SSModel(model)
}
