% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_MIdat.R
\name{get_MIdat}
\alias{get_MIdat}
\title{Extract multiple imputed datasets}
\usage{
get_MIdat(object, m = 10, include = TRUE, start = NULL,
  minspace = 50, seed = NULL, export_to_SPSS = FALSE,
  resdir = NULL, filename = NULL)
}
\arguments{
\item{object}{object inheriting from class 'JointAI'}

\item{m}{number of imputed datasets}

\item{include}{should the original, incomplete data be included?}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{minspace}{minimum number of iterations between iterations chosen as imputed values.}

\item{seed}{optional seed}

\item{export_to_SPSS}{logical; should the completed data be exported to SPSS?}

\item{resdir}{optional directory for results (if unspecified and
\code{export_to_SPSS = TRUE} the current working directory is used)}

\item{filename}{optional file name (without ending; if unspecified and
\code{export_to_SPSS = TRUE} a name is generated automatically)}
}
\value{
A dataframe containing the imputed values (and original data) stacked.
       The variable \code{Imputation_} identifies the imputations, while
       \code{.rownr} identifies rows of the rows of the original data.
       In cross-sectional datasets the
       variable \code{.id} is added as subject identifier.
}
\description{
Creates a dataset containing multiple imputed datasets stacked onto each other
(i.e., long format).
These data can be automatically exported to SPSS (i.e., a .txt file containing the data and a
.sps file containing syntax to generate a .sav file). For the export function
the \href{https://CRAN.R-project.org/package=foreign}{\strong{foreign}} package needs to be installed.
}
\examples{
# fit a model and monitor the imputed values with monitor_params = c(imps = TRUE)
mod <- lm_imp(y~C1 + C2 + M2, data = wideDF, monitor_params = c(imps = TRUE), n.iter = 100)

# Example 1: without export to SPSS
MIs <- get_MIdat(mod, m = 3, seed = 123)

\dontrun{
# Example 2: with export for SPSS (here: to the temporary directory "temp_dir")
temp_dir <- tempdir()
MIs <- get_MIdat(mod, m = 3, seed = 123, resdir = temp_dir,
                 filename = "example_imputation",
                 export_to_SPSS = TRUE)

}
}
\seealso{
\code{\link{plot_imp_distr}}
}
