% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convergence_criteria.R
\name{GR_crit}
\alias{GR_crit}
\title{Gelman-Rubin criterion for convergence}
\usage{
GR_crit(object, confidence = 0.95, transform = FALSE, autoburnin = TRUE,
  multivariate = TRUE, subset = "main", start = NULL, end = NULL,
  thin = NULL, ...)
}
\arguments{
\item{object}{inheriting from class \code{JointAI}}

\item{confidence}{the coverage probability of the confidence interval for the
potential scale reduction factor}

\item{transform}{a logical flag indicating whether variables in
\code{x} should be transformed to improve the normality of the
distribution. If set to TRUE, a log transform or logit transform, as
appropriate, will be applied.}

\item{autoburnin}{a logical flag indicating whether only the second half
  of the series should be used in the computation.  If set to TRUE
  (default) and \code{start(x)} is less than \code{end(x)/2} then start
  of series will be adjusted so that only second half of series is used.}

\item{multivariate}{a logical flag indicating whether the multivariate
potential scale reduction factor should be calculated for multivariate
chains}

\item{subset}{subset of monitored parameters (columns in the MCMC sample).
Can be specified as a numeric vector of columns, a vector of
column names, as \code{subset = "main"} or \code{NULL}.
If \code{NULL}, all monitored nodes will be plotted.
\code{subset = "main"} (default) the main parameters of the
analysis model will be plotted (regression coefficients/fixed
effects, and, if available, standard deviation of the residual
and random effects covariance matrix).}

\item{start}{the first iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{end}{the last iteration of interest (see \code{\link[coda]{window.mcmc}})}

\item{thin}{thinning interval (see \code{\link[coda]{window.mcmc}})}

\item{...}{currently not used}
}
\description{
Gelman-Rubin criterion for convergence (uses \code{\link[coda]{gelman.diag}})
}
\examples{

mod1 <- lm_imp(y~C1 + C2 + M2, data = wideDF, n.iter = 100)
GR_crit(mod1)


}
\references{
Gelman, A., Meng, X. L., & Stern, H. (1996).
Posterior predictive assessment of model fitness via realized discrepancies.
\emph{Statistica Sinica}, 733-760.
}
