% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exports.R
\name{get_jira_dashboards}
\alias{get_jira_dashboards}
\title{Retrieves all dashboards a \code{data.frame}}
\usage{
get_jira_dashboards(
  domain = NULL,
  username = NULL,
  password = NULL,
  maxResults = 20L,
  verbose = FALSE
)
}
\arguments{
\item{domain}{Custom JIRA domain URL as for example
\href{https://bugreports.qt.io}{https://bugreports.qt.io}. Can be passed as a parameter
 or can be previously defined through the \code{save_jira_credentials()} function.}

\item{username}{Username used to authenticate the access to the JIRA \code{domain}.
If both username and password are not passed no authentication is made and only
public domains can bet accessed. Optional parameter.}

\item{password}{Password used to authenticate the access to the JIRA \code{domain}.
If both username and password are not passed no authentication is made and only
public domains can bet accessed. Optional parameter.}

\item{maxResults}{Max results authorized to obtain for each API call. By default
JIRA sets this value to 20 issues.}

\item{verbose}{Explicitly informs the user of the JIRA API request process.}
}
\value{
Returns a flattened, formatted \code{data.frame} with the dashboards in the domain.
}
\description{
Calls JIRA's latest REST API, optionally with
 basic authentication, to get all dashboards
}
\examples{
get_jira_dashboards(domain = "https://bugreports.qt.io")
}
\seealso{
For more information about Atlassians JIRA API visit the following link:
\href{https://docs.atlassian.com/software/jira/docs/api/REST/8.9.1/}{JIRA API Documentation}.
}
