/*
 * Decompiled with CFR 0.152.
 */
package jas;

import jas.ClassEnv;
import jas.CodeAttr;
import jas.Insn;
import jas.InsnOperand;
import jas.Label;
import jas.jasError;
import java.io.DataOutputStream;
import java.io.IOException;

class TableswitchOperand
extends InsnOperand {
    int min;
    int max;
    Label dflt;
    Label[] jmp;
    Insn source;

    TableswitchOperand(Insn s, int min, int max, Label def, Label[] j) {
        this.min = min;
        this.max = max;
        this.dflt = def;
        this.jmp = j;
        this.source = s;
    }

    void resolve(ClassEnv e) {
    }

    int size(ClassEnv ce, CodeAttr code) throws jasError {
        int sz = 12;
        int source_pc = code.getPc(this.source);
        if ((source_pc + 1) % 4 != 0) {
            sz += 4 - (source_pc + 1) % 4;
        }
        if (this.jmp != null) {
            sz += 4 * this.jmp.length;
        }
        return sz;
    }

    void write(ClassEnv e, CodeAttr ce, DataOutputStream out) throws IOException, jasError {
        int source_pc = ce.getPc(this.source);
        if ((source_pc + 1) % 4 != 0) {
            int pad = 4 - (source_pc + 1) % 4;
            int x = 0;
            while (x < pad) {
                out.writeByte(0);
                ++x;
            }
        }
        this.dflt.writeWideOffset(ce, this.source, out);
        out.writeInt(this.min);
        out.writeInt(this.max);
        int cnt = this.jmp.length;
        int x = 0;
        while (x < cnt) {
            this.jmp[x].writeWideOffset(ce, this.source, out);
            ++x;
        }
    }
}

