/*
 * Decompiled with CFR 0.152.
 */
package antlr.preprocessor;

import antlr.collections.impl.Vector;
import antlr.preprocessor.GrammarFile;
import antlr.preprocessor.Hierarchy;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;

public class Tool {
    protected Hierarchy theHierarchy;
    protected String grammarFileName;
    protected String[] args;
    protected int nargs;
    protected Vector grammars;

    public Tool(String[] stringArray) {
        this.processArguments(stringArray);
    }

    public static void main(String[] stringArray) {
        Tool tool = new Tool(stringArray);
        tool.preprocess();
        System.out.print("new argument list to ANTLR: java antlr.Tool ");
        String[] stringArray2 = tool.preprocessedArgList();
        int n = 0;
        while (n < stringArray2.length) {
            System.out.print(" " + stringArray2[n]);
            ++n;
        }
        System.out.println();
    }

    public boolean preprocess() {
        boolean bl;
        Object object;
        if (this.grammarFileName == null) {
            antlr.Tool.toolError("no grammar file specified");
            return false;
        }
        if (this.grammars != null) {
            this.theHierarchy = new Hierarchy();
            Enumeration enumeration = this.grammars.elements();
            while (enumeration.hasMoreElements()) {
                object = (String)enumeration.nextElement();
                try {
                    this.theHierarchy.readGrammarFile((String)object);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    antlr.Tool.toolError("file " + (String)object + " not found");
                    return false;
                }
            }
        }
        if (!(bl = this.theHierarchy.verifyThatHierarchyIsComplete())) {
            return false;
        }
        this.theHierarchy.expandGrammarsInFile(this.grammarFileName);
        object = this.theHierarchy.getFile(this.grammarFileName);
        String string = ((GrammarFile)object).nameForExpandedGrammarFile(this.grammarFileName);
        try {
            ((GrammarFile)object).generateExpandedFile();
            this.args[this.nargs++] = string;
        }
        catch (IOException iOException) {
            antlr.Tool.toolError("cannot write expanded grammar file " + string);
            return false;
        }
        return true;
    }

    public String[] preprocessedArgList() {
        String[] stringArray = new String[this.nargs];
        System.arraycopy(this.args, 0, stringArray, 0, this.nargs);
        this.args = stringArray;
        return this.args;
    }

    private void processArguments(String[] stringArray) {
        this.nargs = 0;
        this.args = new String[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("-glib")) {
                this.grammars = antlr.Tool.parseSeparatedList(stringArray[n + 1], ';');
                ++n;
            } else if (stringArray[n].charAt(0) == '-') {
                this.args[this.nargs++] = stringArray[n];
            } else {
                this.grammarFileName = stringArray[n];
                if (this.grammars == null) {
                    this.grammars = new Vector(10);
                }
                this.grammars.appendElement(this.grammarFileName);
            }
            ++n;
        }
    }
}

