/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Interpreter;

import java.util.Hashtable;
import java.util.Vector;
import org.omegahat.Environment.Interpreter.Evaluator;
import org.omegahat.Environment.Interpreter.InteractiveEvaluator;
import org.omegahat.Environment.Interpreter.ManagedEvaluatorInt;
import org.omegahat.Environment.Interpreter.Options;
import org.omegahat.Environment.Parser.Parse.ConstructorExpression;
import org.omegahat.Environment.System.Globals;
import org.omegahat.Environment.Tools.FileLocator.FileLocator;
import org.omegahat.Environment.Tools.FileLocator.FileLocatorInt;
import org.omegahat.Environment.Tools.VariableExpansion.VariableExpansion;

public class EvaluatorManager {
    public static String EvaluatorClassName = "evaluatorClassName";
    public String FinalScriptProperty = "OmegaFinalScript";
    public final String OmegaScriptSearchPath = "OmegahatSearchPath";
    protected String[] commandLineArgs = null;
    protected Vector evaluators = new Vector();
    protected Hashtable evaluatorThreads = new Hashtable(5);
    protected Options options = null;
    protected FileLocatorInt fileLocator = null;

    public EvaluatorManager() {
        Globals.manager(this);
    }

    public EvaluatorManager(ManagedEvaluatorInt managedEvaluatorInt) {
        this();
        managedEvaluatorInt.manager(this);
        this.addEvaluator(managedEvaluatorInt);
    }

    public EvaluatorManager(Options options) {
        this();
        this.options(options);
    }

    public EvaluatorManager(String[] stringArray) {
        this();
        this.commandLine(stringArray);
    }

    public ManagedEvaluatorInt addEvaluator(ManagedEvaluatorInt managedEvaluatorInt) {
        managedEvaluatorInt.manager(this);
        if (!this.evaluators().contains(managedEvaluatorInt)) {
            this.evaluators().addElement(managedEvaluatorInt);
        }
        Thread thread = Thread.currentThread();
        this.evaluatorThreads().put(thread, managedEvaluatorInt);
        return managedEvaluatorInt;
    }

    public String[] commandLine() {
        return this.commandLineArgs;
    }

    public String[] commandLine(String[] stringArray) {
        this.commandLineArgs = stringArray;
        return this.commandLine();
    }

    public Evaluator createEvaluator(Evaluator evaluator) {
        InteractiveEvaluator interactiveEvaluator = evaluator == null ? new InteractiveEvaluator() : new InteractiveEvaluator(evaluator);
        return interactiveEvaluator;
    }

    public Evaluator evaluator() throws ClassNotFoundException {
        return this.evaluator(true);
    }

    public Evaluator evaluator(String string) throws ClassNotFoundException, Throwable {
        return this.evaluator(string, null);
    }

    public Evaluator evaluator(String string, Evaluator evaluator) throws ClassNotFoundException, Throwable {
        Evaluator evaluator2 = null;
        if (evaluator != null) {
            Object[] objectArray = new Object[]{evaluator};
            ConstructorExpression constructorExpression = new ConstructorExpression(string, objectArray, false);
            evaluator2 = (Evaluator)constructorExpression.eval(evaluator);
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                evaluator2 = (Evaluator)clazz.newInstance();
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                evaluator2 = new InteractiveEvaluator();
            }
        }
        if (evaluator2 instanceof ManagedEvaluatorInt) {
            this.addEvaluator((ManagedEvaluatorInt)evaluator2);
        }
        return evaluator2;
    }

    public Evaluator evaluator(Thread thread) {
        if (this.evaluatorThreads().containsKey(thread)) {
            return (Evaluator)this.evaluatorThreads().get(thread);
        }
        Evaluator evaluator = null;
        try {
            evaluator = this.evaluator(false);
        }
        catch (ClassNotFoundException classNotFoundException) {}
        return evaluator;
    }

    public Evaluator evaluator(Evaluator evaluator) throws ClassNotFoundException {
        Evaluator evaluator2;
        String string = null;
        if (((Hashtable)System.getProperties()).containsKey(EvaluatorClassName)) {
            string = System.getProperty(EvaluatorClassName);
        } else {
            if (evaluator != null && evaluator.options() != null) {
                string = (String)((Hashtable)evaluator.options()).get(EvaluatorClassName);
            }
            if (string == null) {
                string = (String)((Hashtable)this.options()).get(EvaluatorClassName);
            }
            if (string == null) {
                try {
                    Class<?> clazz = Class.forName("javax.help.JHelp");
                    string = "org.omegahat.Environment.Interpreter.GUIHelpEvaluator";
                }
                catch (Exception exception) {
                    string = "org.omegahat.Environment.Interpreter.InteractiveEvaluator";
                }
            }
        }
        if (string != null) {
            try {
                return this.evaluator(string, evaluator);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw classNotFoundException;
            }
            catch (Throwable throwable) {
                if (evaluator != null) {
                    try {
                        throw (RuntimeException)evaluator.error(throwable, "Can't create new evaluator from " + string);
                    }
                    catch (Throwable throwable2) {
                    }
                } else {
                    System.err.println("Problem creating evaluator " + string);
                }
                throwable.printStackTrace();
            }
        }
        if ((evaluator2 = this.createEvaluator(evaluator)) instanceof ManagedEvaluatorInt) {
            this.addEvaluator((ManagedEvaluatorInt)evaluator2);
        }
        return evaluator2;
    }

    public Evaluator evaluator(boolean bl) throws ClassNotFoundException {
        if (this.evaluators().size() == 0) {
            if (bl) {
                this.evaluator((Evaluator)null);
            } else {
                return null;
            }
        }
        return (Evaluator)this.evaluators().elementAt(0);
    }

    public Hashtable evaluatorThreads() {
        return this.evaluatorThreads;
    }

    public Vector evaluators() {
        return this.evaluators;
    }

    public void exit(int n) {
        try {
            this.exit(this.evaluator(), n);
        }
        catch (Throwable throwable) {
            System.err.println("Problem exiting. Immediate exit in effect!");
            System.exit(n);
        }
    }

    public void exit(Evaluator evaluator) {
        this.exit(evaluator, 0);
    }

    public void exit(Evaluator evaluator, int n) {
        Thread.currentThread().setPriority(10);
        try {
            String string;
            Object object = this.findFile(System.getProperty(this.FinalScriptProperty));
            if (object == null && (string = evaluator.options().getProperty(this.FinalScriptProperty)) != null) {
                object = this.findFile(string);
            }
            if (object != null) {
                evaluator.source(object);
            }
        }
        catch (Throwable throwable) {
            System.out.println("Terminate script failed: " + throwable);
            throwable.printStackTrace();
        }
        System.exit(n);
    }

    public FileLocatorInt fileLocator() {
        if (this.fileLocator == null) {
            String string = new Options().getProperty("OmegahatSearchPath", true);
            if (string == null) {
                string = String.valueOf(System.getProperty("OMEGA_HOME")) + "/Environment";
            }
            if (string == "/Environment") {
                System.err.println("No value for OMEGA_HOME");
                return null;
            }
            VariableExpansion variableExpansion = new VariableExpansion(string, System.getProperties());
            string = variableExpansion.expandString();
            System.err.println("FileLocator path: " + string);
            this.fileLocator(new FileLocator(string));
        }
        return this.fileLocator;
    }

    public FileLocatorInt fileLocator(FileLocatorInt fileLocatorInt) {
        this.fileLocator = fileLocatorInt;
        return this.fileLocator();
    }

    public Object findFile(String string) {
        FileLocatorInt fileLocatorInt = this.fileLocator();
        Object object = null;
        if (fileLocatorInt != null) {
            object = fileLocatorInt.find(string);
        }
        return object;
    }

    public int manager(Evaluator evaluator) {
        if (evaluator == null) {
            return -1;
        }
        if (!this.evaluators().contains(evaluator) && evaluator instanceof ManagedEvaluatorInt) {
            ManagedEvaluatorInt managedEvaluatorInt = (ManagedEvaluatorInt)evaluator;
            this.evaluators().addElement(managedEvaluatorInt);
            managedEvaluatorInt.manager(this);
        }
        return this.evaluators().size();
    }

    public Options options() {
        if (this.options == null) {
            this.options(new Options());
        }
        return this.options;
    }

    public Options options(Options options) {
        this.options = options;
        return this.options();
    }

    public boolean q(Evaluator evaluator) {
        return this.q(evaluator, false);
    }

    public boolean q(Evaluator evaluator, boolean bl) {
        if (bl || this.evaluators().size() == 1) {
            this.exit(evaluator);
        } else if (this.evaluators().contains(evaluator)) {
            this.evaluators().removeElement(evaluator);
        }
        return true;
    }
}

