% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{meanDeviations}
\alias{meanDeviations}
\title{Function to calculate the mean and deviations from mean}
\usage{
meanDeviations(x, na.rm = TRUE)
}
\arguments{
\item{x}{A vector, appropriate for the \code{mean}
function.}

\item{na.rm}{A logical, whether to remove missing
or not.  Defaults to \code{TRUE}.}
}
\value{
A list of the mean (first element) and deviations
  from the mean (second element).
}
\description{
Tiny helper function to calculate the mean and
deviations from the mean, both returned as a list.
Works nicely with data.table to calculate a between and
within variable.
}
\examples{
## simple example showing what it does
meanDeviations(1:10)

## example use case, applied to a data.table
d <- as.data.table(iris)
d[, c("BSepal.Length", "WSepal.Length") := meanDeviations(Sepal.Length),
  by = Species]
str(d)
}
