% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rowtens.R
\name{rowtens}
\alias{rowtens}
\title{Compute the row tensor product of two matrices}
\usage{
rowtens(X, Y = X)
}
\arguments{
\item{X}{a numeric matrix.}

\item{Y}{a numeric matrix (if missing, \code{Y = x}).}
}
\value{
The row-wise tensor product of the two matrices.
}
\description{
Compute the row tensor product of two matrices with identical numbers of rows.
}
\details{
The input matrices must have the same number of rows, say \code{m}. If their numbers of columns are \code{n1} and \code{n2},
the result is a matrix with \code{m} rows and \code{n1 * n2} columns. Each row of the result is the Kronecker
product of the corresponding rows of \code{X} and \code{Y}.
}
\references{
Eilers, P. H. C. and Currie, I. D. and Durban, M. (2006)
Fast and compact smoothing on large multidimensional grids
\emph{CSDA} 50, 61--76.
}
\author{
Paul Eilers
}
