/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.TextFinder;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenuSwing;
import org.rosuda.ibase.toolkit.TJFrame;

public class TextPager
extends TJFrame
implements ActionListener {
    private static final long serialVersionUID = -2204127122909644542L;
    JTextArea t = new JTextArea();
    TextFinder textFinder = new TextFinder(this.t);

    public TextPager(String file, String header, String title, boolean deleteFile) {
        super(title, 16);
        String[] myMenu = new String[]{"+", "Edit", "@CCopy", "copy", "-", "@FFind", "search", "@GFind next", "searchnext", "~Window", "0"};
        EzMenuSwing.getEzMenu(this, this, myMenu);
        this.getContentPane().add(new JScrollPane(this.t));
        this.t.setEditable(false);
        this.t.setFont(new Font("Monospaced", 0, 10));
        this.t.setDragEnabled(true);
        FontTracker.current.add(this.t);
        this.t.setBackground(Color.white);
        this.setSize(400, 600);
        try {
            BufferedReader r = new BufferedReader(new FileReader(file));
            while (r.ready()) {
                this.t.append(r.readLine());
                this.t.append("\n");
            }
            r.close();
            r = null;
            if (deleteFile) {
                new File(file).delete();
            }
        }
        catch (Exception e) {
            this.t.append("Unable to open file \"" + file + "\": " + e.getMessage());
        }
        this.addWindowListener(Common.getDefaultWindowListener());
        this.setVisible(true);
    }

    public static void launchPager(String file, String header, String title, boolean deleteFile) {
        new TextPager(file, header, title, deleteFile);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd == "copy") {
            this.t.copy();
        } else if (cmd == "search") {
            this.textFinder.showFind(false);
        } else if (cmd == "searchnext") {
            this.textFinder.showFind(true);
        }
    }
}

