/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.event.ActionListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import org.rosuda.JGR.toolkit.IconButton;

public class EditorUndoManager
extends UndoManager {
    private static final long serialVersionUID = 1713007948262571134L;
    public IconButton undoButton;
    public IconButton redoButton;

    public EditorUndoManager(ActionListener al) {
        this.setLimit(10000);
        this.undoButton = new IconButton("/icons/undo.png", "Undo", al, "undo");
        this.redoButton = new IconButton("/icons/redo.png", "Redo", al, "redo");
        this.undoButton.setEnabled(false);
        this.redoButton.setEnabled(false);
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        UndoableEdit ue = e.getEdit();
        if (ue instanceof AbstractDocument.DefaultDocumentEvent && ((AbstractDocument.DefaultDocumentEvent)ue).getType() == DocumentEvent.EventType.CHANGE) {
            return;
        }
        this.addEdit(ue);
        this.undoButton.setEnabled(true);
    }

    public void undo() {
        super.undo();
        if (!this.canUndo()) {
            this.undoButton.setEnabled(false);
        }
        this.redoButton.setEnabled(true);
    }

    public void redo() {
        super.redo();
        if (!this.canRedo()) {
            this.redoButton.setEnabled(false);
        }
        this.undoButton.setEnabled(true);
    }
}

