/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.toolkit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import org.rosuda.JGR.util.ErrorMsg;

public class ProgressLabel
extends Canvas
implements Runnable {
    private static final long serialVersionUID = 5665615547332756827L;
    private Thread thread;
    private boolean next = false;
    private int angle = 0;
    private int x;
    private int length;
    private int a;
    private final int gap = 16;
    private Image img = null;
    private Graphics g2 = null;
    private final Color col = Color.darkGray;
    private final int sleep = 240;

    public ProgressLabel(int n) {
        this.setSize(n + 10, n + 10);
        this.x = n / 2;
        this.length = this.x - this.x / 10;
        this.x += 5;
        this.a = this.length * 3 / 5;
    }

    public void update(Graphics graphics) {
        if (this.img == null) {
            this.img = this.createImage(this.getWidth(), this.getHeight());
            this.g2 = this.img.getGraphics();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g2.setColor(this.getBackground());
        this.g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.drawProgress(this.g2);
        graphics.drawImage(this.img, 0, 0, this);
    }

    private void drawProgress(Graphics graphics) {
        for (int i = 0; i < 360; i += 32) {
            if (i >= this.angle * 6 && i <= this.angle * 6 + 90) {
                graphics.setColor(new Color(this.col.getRed(), this.col.getGreen(), this.col.getBlue(), 200));
            } else {
                graphics.setColor(new Color(0, 0, 0, (360 - i + 100 - this.angle) / 10));
            }
            graphics.fillArc(this.x - this.length, this.x - this.length, 2 * this.length, 2 * this.length, -i, 16);
        }
        graphics.setColor(this.getBackground());
        graphics.fillArc(this.x - this.a, this.x - this.a, 2 * this.a, 2 * this.a, 0, 360);
    }

    public void start() {
        if (this.isVisible()) {
            this.next = true;
        }
        this.setVisible(true);
        this.thread = new Thread(this);
        if (this.thread != null) {
            this.thread.start();
        }
    }

    public void stop() {
        this.setVisible(false);
        try {
            if (this.thread != null) {
                this.thread.interrupt();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
        this.thread = null;
        if (this.next) {
            this.next = false;
            this.start();
        }
    }

    public void run() {
        try {
            while (this.isVisible()) {
                Thread.sleep(240L);
                this.angle = (this.angle + 10) % 60;
                this.repaint();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }
}

