/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.toolkit.JComboBoxExt;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JRI.REXP;

public class JGRDataFileOpenDialog
extends JFileChooser
implements ActionListener,
ItemListener,
PropertyChangeListener {
    private final JTextField dataName = new JTextField();
    private final JTextField otherSeps = new JTextField();
    private final JCheckBox header = new JCheckBox("Header", true);
    private final JCheckBox attach = new JCheckBox("Attach", false);
    private final JComboBoxExt sepsBox = new JComboBoxExt(new String[]{"\\t", "\\w", ",", ";", "|", "Others..."});
    private final String[] seps = new String[]{"\\t", "", ",", ";", "|"};
    private final JComboBoxExt quoteBox = new JComboBoxExt(new String[]{"None", "\\\"", "\\'", "Others..."});
    private final String[] quotes = new String[]{"", "\\\"", "\\'"};
    private boolean nameAccepted = false;

    public JGRDataFileOpenDialog(Frame frame, String string) {
        this.dataName.setMinimumSize(new Dimension(180, 22));
        this.dataName.setPreferredSize(new Dimension(180, 22));
        this.dataName.setMaximumSize(new Dimension(180, 22));
        this.quoteBox.setMinimumSize(new Dimension(90, 22));
        this.quoteBox.setPreferredSize(new Dimension(90, 22));
        this.quoteBox.setMaximumSize(new Dimension(90, 22));
        this.sepsBox.setMinimumSize(new Dimension(90, 22));
        this.sepsBox.setPreferredSize(new Dimension(90, 22));
        this.sepsBox.setMaximumSize(new Dimension(90, 22));
        this.quoteBox.addItemListener(this);
        this.sepsBox.addItemListener(this);
        this.addActionListener(this);
        this.addPropertyChangeListener(this);
        if (string != null && new File(string).exists()) {
            this.setCurrentDirectory(new File(string));
        }
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        jPanel2.add(new JLabel(" read.table(...) -> "));
        jPanel2.add(this.dataName);
        JPanel jPanel3 = new JPanel(new FlowLayout(0));
        jPanel3.add(this.header);
        jPanel3.add(new JLabel(", sep="));
        jPanel3.add(this.sepsBox);
        jPanel3.add(new JLabel(", quote="));
        jPanel3.add(this.quoteBox);
        JPanel jPanel4 = new JPanel(new FlowLayout(0));
        jPanel4.add(this.attach);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel.add(jPanel4);
        if (System.getProperty("os.name").startsWith("Window")) {
            try {
                JPanel jPanel5 = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(2);
                jPanel5.add(jPanel2);
                jPanel5.add(jPanel3);
                jPanel5.add(jPanel4);
                JPanel jPanel6 = (JPanel)((JComponent)((JComponent)this.getComponent(2)).getComponent(2)).getComponent(0);
                jPanel6.add(new JPanel());
                this.setPreferredSize(new Dimension(660, 450));
            }
            catch (Exception exception) {
                JPanel jPanel7 = (JPanel)this.getComponent(this.getComponentCount() - 1);
                JPanel jPanel8 = (JPanel)jPanel7.getComponent(jPanel7.getComponentCount() - 1);
                this.setControlButtonsAreShown(false);
                jPanel7.add(jPanel2);
                jPanel7.add(jPanel3);
                jPanel7.add(jPanel4);
                jPanel7.add(jPanel8);
                this.setPreferredSize(new Dimension(550, 450));
            }
        } else {
            JPanel jPanel9 = (JPanel)this.getComponent(this.getComponentCount() - 1);
            JPanel jPanel10 = (JPanel)jPanel9.getComponent(jPanel9.getComponentCount() - 1);
            this.setControlButtonsAreShown(false);
            jPanel9.add(jPanel2);
            jPanel9.add(jPanel3);
            jPanel9.add(jPanel4);
            jPanel9.add(jPanel10);
            this.setPreferredSize(new Dimension(550, 450));
        }
        this.setFileHidingEnabled(!JGRPrefs.showHiddenFiles);
        this.showOpenDialog(frame);
    }

    public void loadFile() {
        if (this.getSelectedFile() != null) {
            JGRPrefs.workingDirectory = this.getCurrentDirectory().getAbsolutePath() + File.separator;
            String string = this.getSelectedFile().toString();
            String string2 = this.sepsBox.getSelectedIndex() >= this.seps.length ? this.sepsBox.getSelectedItem().toString() : this.seps[this.sepsBox.getSelectedIndex()];
            String string3 = this.quoteBox.getSelectedIndex() >= this.quotes.length ? this.quoteBox.getSelectedItem().toString() : this.quotes[this.quoteBox.getSelectedIndex()];
            String string4 = this.dataName.getText().trim().replaceAll("\\s", "") + " <- read.table(\"" + string.replace('\\', '/') + "\",header=" + (this.header.isSelected() ? "T" : "F") + ",sep=\"" + string2 + "\", quote=\"" + string3 + "\")" + (this.attach.isSelected() ? ";attach(" + this.dataName.getText().trim().replaceAll("\\s", "") + ")" : "") + "";
            JGR.MAINRCONSOLE.execute(string4, true);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "ApproveSelection") {
            this.loadFile();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        boolean bl = false;
        if (itemSelectable == this.quoteBox) {
            bl = this.quoteBox.getSelectedIndex() == this.quoteBox.getItemCount() - 1;
            this.quoteBox.setEditable(bl);
        } else if (itemSelectable == this.sepsBox) {
            bl = this.sepsBox.getSelectedIndex() == this.sepsBox.getItemCount() - 1;
            this.sepsBox.setEditable(bl);
        }
    }

    private void checkFile(File file) {
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = null;
            String string2 = null;
            if (bufferedReader.ready()) {
                string = bufferedReader.readLine();
            }
            if (bufferedReader.ready()) {
                string2 = bufferedReader.readLine();
            }
            bufferedReader.close();
            if (string2 != null) {
                int n = string2.indexOf("\"");
                if (n > -1 && string2.indexOf("\"", n + 1) > -1) {
                    this.quoteBox.setSelectedItem("\\\"");
                } else {
                    n = string2.indexOf("'");
                    if (n > -1 && string2.indexOf("'", n + 1) > -1) {
                        this.quoteBox.setSelectedItem("\\'");
                    } else {
                        this.quoteBox.setSelectedItem("None");
                    }
                }
                this.sepsBox.setSelectedItem("\\w");
                n = string2.indexOf("\t");
                if (n > -1 && string2.indexOf("\t", n + 1) > -1) {
                    this.sepsBox.setSelectedItem("\\t");
                }
                if ((n = string2.indexOf(";")) > -1 && string2.indexOf(";", n + 1) > -1) {
                    this.sepsBox.setSelectedItem(";");
                }
                if ((n = string2.indexOf(",")) > -1 && string2.indexOf(",", n + 1) > -1) {
                    this.sepsBox.setSelectedItem(",");
                }
                if ((n = string2.indexOf("|")) > -1 && string2.indexOf("|", n + 1) > -1) {
                    this.sepsBox.setSelectedItem("|");
                }
                if ((n = string2.indexOf("\\w")) == string2.indexOf("\n")) {
                    this.sepsBox.setSelectedItem("\\t");
                }
            }
            if (string != null && string2 != null) {
                String string3 = this.seps[this.sepsBox.getSelectedIndex()];
                string3 = string3 == "\\t" ? "\t" : string3;
                int n = 0;
                int n2 = 0;
                if (string3.length() == 0) {
                    n = new StringTokenizer(string).countTokens();
                    n2 = new StringTokenizer(string2).countTokens();
                } else {
                    int n3 = -1;
                    while ((n3 = string.trim().indexOf(string3, n3 + 1)) > -1) {
                        ++n;
                    }
                    n3 = -1;
                    while ((n3 = string2.trim().indexOf(string3, n3 + 1)) > -1) {
                        ++n2;
                    }
                }
                if (n + 1 == n2 || n == n2 && string.matches("^[a-zA-Z\"].*")) {
                    this.header.setSelected(true);
                } else {
                    this.header.setSelected(false);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        File file = this.getSelectedFile();
        if (file != null && !file.isDirectory() && !this.nameAccepted) {
            String string = file.getName().replaceAll("\\..*", "");
            string = string.replaceAll("^[0-9]+|[^a-zA-Z|^0-9|^_]", ".");
            REXP rEXP = JGR.R.idleEval("try(.refreshObjects(),silent=TRUE)");
            String[] stringArray = null;
            if (rEXP != null && (stringArray = rEXP.asStringArray()) != null) {
                JGR.setObjects(stringArray);
            }
            while (JGR.OBJECTS.contains(string) && !this.nameAccepted) {
                String string2 = (String)JOptionPane.showInputDialog(new JTextField(), "Object name already used!", "Object " + string + " exists!", -1, null, null, string);
                if (string2 != null) {
                    string = string2;
                }
                this.nameAccepted = true;
            }
            this.dataName.setText(string);
            this.checkFile(file);
        } else {
            this.dataName.setText(null);
        }
    }
}

