/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR.editor;

import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;

public class LineNumbers
extends JComponent
implements AdjustmentListener {
    private Dimension d = new Dimension();
    private boolean showing = true;
    private int BAR = 4;
    private JTextComponent src;
    private JScrollPane scroller;
    private Dimension sizeCache = new Dimension();
    private Point locCache = new Point();

    public LineNumbers(JTextComponent jTextComponent, JScrollPane jScrollPane) {
        this.src = jTextComponent;
        this.scroller = jScrollPane;
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (LineNumbers.this.showing) {
                    LineNumbers.this.hideBar();
                } else {
                    LineNumbers.this.showBar();
                }
            }
        });
        jScrollPane.getVerticalScrollBar().addAdjustmentListener(this);
        super.setFont(jTextComponent.getFont());
        this.setBorder(BorderFactory.createRaisedBevelBorder());
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        this.scroller.validate();
    }

    private void hideBar() {
        this.showing = false;
        this.scroller.setRowHeaderView(this);
    }

    private void showBar() {
        this.showing = true;
        this.scroller.setRowHeaderView(this);
    }

    private void paintNumbers(Graphics graphics) {
        graphics.setColor(UIManager.getColor("InternalFrame.activeTitleBackground"));
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.getBorder().getBorderInsets(this);
        rectangle.width -= insets.right + insets.left;
        rectangle.x += insets.left;
        ((Graphics2D)graphics).fill(rectangle);
        int n = this.getFontMetrics(this.getFont()).getAscent();
        int n2 = this.getFontMetrics(this.getFont()).getHeight();
        int n3 = (int)(rectangle.getY() / (double)n2) * n2;
        int n4 = (int)(rectangle.getY() + rectangle.getHeight()) / n2;
        graphics.setColor(UIManager.getColor("Label.foreground"));
        for (int i = (int)Math.floor(n3 / n2) + 1; i <= n4 + 1; ++i) {
            graphics.drawString(i + "", insets.left, n3 + n);
            n3 += n2;
        }
    }

    public Dimension getPreferredSize() {
        this.d.width = this.getMyWidth();
        this.d.height = this.src.getHeight();
        return this.d;
    }

    private int getLineCount() {
        Element element = this.src.getDocument().getDefaultRootElement();
        return element.getElementCount();
    }

    private int getMyWidth() {
        FontMetrics fontMetrics = this.src.getFontMetrics(this.src.getFont());
        int n = this.src.getHeight() / fontMetrics.getHeight();
        return this.showing ? fontMetrics.stringWidth(this.getVisibleEndLine() + "") + 4 + this.BAR : this.BAR;
    }

    private int getVisibleStartLine() {
        this.scroller.getViewport().getView().getLocation(this.locCache);
        int n = this.getFontMetrics(this.getFont()).getAscent();
        int n2 = this.getFontMetrics(this.getFont()).getHeight();
        int n3 = (int)(this.locCache.getY() / (double)n2) * n2;
        return (int)Math.floor(n3 / n2) + 1;
    }

    private int getVisibleEndLine() {
        this.scroller.getViewport().getView().getLocation(this.locCache);
        this.scroller.getViewport().getSize(this.sizeCache);
        int n = this.getFontMetrics(this.getFont()).getAscent();
        int n2 = this.getFontMetrics(this.getFont()).getHeight();
        return (int)Math.abs(-this.locCache.getY() + this.sizeCache.getHeight()) / n2;
    }

    public void paint(Graphics graphics) {
        this.getBorder().paintBorder(this, graphics, 0, 0, this.d.width, this.d.height + 1);
        if (this.showing) {
            this.paintNumbers(graphics);
        }
    }
}

