/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.JGR;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.undo.CannotUndoException;
import org.rosuda.JGR.JGR;
import org.rosuda.JGR.JGRDataFileOpenDialog;
import org.rosuda.JGR.JGRHelp;
import org.rosuda.JGR.RController;
import org.rosuda.JGR.editor.Editor;
import org.rosuda.JGR.editor.FindReplaceDialog;
import org.rosuda.JGR.toolkit.AboutDialog;
import org.rosuda.JGR.toolkit.ConsoleOutput;
import org.rosuda.JGR.toolkit.DataTable;
import org.rosuda.JGR.toolkit.FileSelector;
import org.rosuda.JGR.toolkit.FontTracker;
import org.rosuda.JGR.toolkit.JGRPrefs;
import org.rosuda.JGR.toolkit.PrefsDialog;
import org.rosuda.JGR.toolkit.SelectionPreservingCaret;
import org.rosuda.JGR.toolkit.SyntaxInput;
import org.rosuda.JGR.toolkit.TextFinder;
import org.rosuda.JGR.toolkit.ToolBar;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.JRI.RMainLoopCallbacks;
import org.rosuda.JRI.Rengine;
import org.rosuda.ibase.Common;
import org.rosuda.ibase.toolkit.EzMenu;
import org.rosuda.ibase.toolkit.TJFrame;
import org.rosuda.ibase.toolkit.WTentry;
import org.rosuda.ibase.toolkit.WinTracker;

public class JGRConsole
extends TJFrame
implements ActionListener,
KeyListener,
FocusListener,
RMainLoopCallbacks {
    private final JSplitPane consolePanel = new JSplitPane(0);
    public ConsoleOutput output = new ConsoleOutput();
    public SyntaxInput input = new SyntaxInput("console", true);
    private final Document inputDoc = this.input.getDocument();
    private final Document outputDoc = this.output.getDocument();
    private final TextFinder textFinder = new TextFinder(this.output);
    private ToolBar toolBar;
    private String wspace = null;
    private int currentHistPosition = 0;
    private final StringBuffer console = new StringBuffer();
    private boolean wasHistEvent = false;
    public int end = 0;
    private Integer clearpoint = null;

    public JGRConsole() {
        this(null);
    }

    public JGRConsole(File file) {
        super("Console", false, 1);
        Accessible accessible;
        Accessible accessible2;
        String[] stringArray = new String[]{"+", "File", "Load Datafile", "loaddata", "-", "@NNew Document", "new", "@OOpen Document", "open", "!OSource File...", "source", "@SSave", "save", "-", "@DSet Working Directory", "setwd", "~File.Quit", "+", "Edit", "@ZUndo", "undo", "!ZRedo", "redo", "-", "@XCut", "cut", "@CCopy", "copy", "#Copy Special", "-", "@VPaste", "paste", "Delete", "delete", "@ASelect All", "selAll", "-", "@FFind", "search", "@GFind Next", "searchnext", "-", "@LClear Console", "clearconsole", "+", "Tools", "Editor", "editor", "@BObject Browser", "objectmgr", "DataTable", "table", "-", "!IIncrease Font Size", "fontBigger", "!DDecrease Font Size", "fontSmaller", "+", "Packages", "Package Manager", "packagemgr", "+", "Workspace", "Load Workspace", "openwsp", "Save Workspace", "savewsp", "Save Workspace as", "saveaswsp", "Clear Workspace", "clearwsp", "~Window", "+", "Help", "R Help", "help", "~Preferences", "~About", "0"};
        EzMenu.getEzMenu((Frame)((Object)this), (ActionListener)this, (String[])stringArray);
        if (JGR.RHISTORY == null) {
            JGR.RHISTORY = new Vector();
        }
        this.currentHistPosition = JGR.RHISTORY.size();
        Menu menu = (Menu)EzMenu.getItem((Frame)((Object)this), (String)"Copy Special");
        if (menu != null) {
            accessible2 = new MenuItem("Copy Output");
            ((MenuItem)accessible2).setActionCommand("copyoutput");
            ((MenuItem)accessible2).addActionListener(this);
            menu.add((MenuItem)accessible2);
            accessible = new MenuItem("Copy Commands");
            ((MenuItem)accessible).setActionCommand("copycmds");
            ((MenuItem)accessible).addActionListener(this);
            menu.add((MenuItem)accessible);
            MenuItem menuItem = new MenuItem("Copy Result");
            menuItem.setActionCommand("copyresult");
            menuItem.addActionListener(this);
            menu.add(menuItem);
        }
        this.toolBar = new ToolBar(this, true);
        this.input.addKeyListener(this);
        this.input.setWordWrap(false);
        this.input.addFocusListener(this);
        this.inputDoc.addUndoableEditListener(this.toolBar.undoMgr);
        this.output.setEditable(false);
        this.output.addFocusListener(this);
        this.output.addKeyListener(this);
        this.output.setDragEnabled(true);
        this.output.setCaret(new SelectionPreservingCaret());
        accessible2 = new JScrollPane(this.output);
        ((JScrollPane)accessible2).setVerticalScrollBarPolicy(22);
        this.consolePanel.setTopComponent((Component)((Object)accessible2));
        accessible = new JScrollPane(this.input);
        ((JScrollPane)accessible).setVerticalScrollBarPolicy(22);
        this.consolePanel.setBottomComponent((Component)((Object)accessible));
        this.consolePanel.setDividerLocation((int)((double)this.getHeight() * 0.65));
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                super.componentResized(componentEvent);
                if (JGR.R != null && JGR.STARTED) {
                    JGR.R.eval("options(width=" + JGRConsole.this.getFontWidth() + ")");
                }
                JGRConsole.this.consolePanel.setDividerLocation((int)((double)JGRConsole.this.getHeight() * 0.65));
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JGRConsole.this.dispose();
            }
        });
        this.addKeyListener(this);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.toolBar, "North");
        this.getContentPane().add((Component)this.consolePanel, "Center");
        this.setMinimumSize(new Dimension(555, 650));
        this.setSize(new Dimension(600, Common.screenRes.height < 800 ? Common.screenRes.height - 50 : 700));
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.input.mComplete.setVisible(false);
    }

    public void exit() {
        Enumeration enumeration = WinTracker.current.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry.wclass != 150 || ((Editor)((Object)wTentry.w)).exit()) continue;
            return;
        }
        this.execute("q()", false);
    }

    public void dispose() {
        Enumeration enumeration = WinTracker.current.elements();
        while (enumeration.hasMoreElements()) {
            WTentry wTentry = (WTentry)enumeration.nextElement();
            if (wTentry.wclass != 150 || ((Editor)((Object)wTentry.w)).exit()) continue;
            return;
        }
        this.execute("q()", false);
    }

    public void execute(String string, boolean bl) {
        if (!JGR.STARTED) {
            return;
        }
        if (bl && JGR.RHISTORY.size() == 0) {
            JGR.RHISTORY.add(string);
        } else if (bl && string.trim().length() > 0 && JGR.RHISTORY.size() > 0 && !JGR.RHISTORY.lastElement().equals(string.trim())) {
            JGR.RHISTORY.add(string);
        }
        this.currentHistPosition = JGR.RHISTORY.size();
        String[] stringArray = string.split("\n");
        String string2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            string2 = stringArray[i];
            if (this.isHelpCMD(string2)) {
                try {
                    this.outputDoc.insertString(this.outputDoc.getLength(), string2 + "\n" + RController.getRPrompt(), JGRPrefs.CMD);
                }
                catch (Exception exception) {}
                continue;
            }
            if (!this.isSupported(string2)) continue;
            JGR.rSync.triggerNotification(string2.trim());
        }
    }

    public boolean isHelpCMD(String string) {
        if ((string = string.trim()).startsWith("help(") || string.startsWith("?") || string.startsWith("help.start(") || string.startsWith("help.search(")) {
            this.help(string);
            return true;
        }
        return false;
    }

    private boolean isSupported(String string) {
        if ((string = string.trim()).startsWith("fix(") || string.startsWith("edit(") || string.startsWith("edit.data.frame(")) {
            try {
                this.outputDoc.insertString(this.outputDoc.getLength(), string + "\n", JGRPrefs.CMD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.outputDoc.insertString(this.outputDoc.getLength(), "Editing is not supported yet!", JGRPrefs.RESULT);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.outputDoc.insertString(this.outputDoc.getLength(), "\n" + RController.getRPrompt(), JGRPrefs.CMD);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public void help(String string) {
        boolean bl = false;
        if (string != null) {
            if ((string = string.replaceAll("[\"|(|)]", "")).startsWith("help.search")) {
                string = string.replaceFirst("help.search", "");
            } else if (string.startsWith("help.start")) {
                string = null;
            } else {
                string = string.trim().startsWith("?") ? string.replaceFirst("\\?", "") : string.replaceFirst("help", "");
                bl = true;
            }
        }
        final boolean bl2 = bl;
        if (JGRHelp.current == null) {
            final String string2 = string != null ? string.trim() : null;
            Thread thread = new Thread(){

                public void run() {
                    JGRConsole.this.setWorking(true);
                    try {
                        new JGRHelp();
                        if (string2 != null) {
                            JGRHelp.current.search(string2, bl2);
                        }
                    }
                    catch (Exception exception) {
                        new ErrorMsg(exception);
                    }
                    JGRConsole.this.setWorking(false);
                }
            };
            thread.start();
        } else if (string != null && string.trim().length() > 0) {
            final String string3 = string.trim();
            Thread thread = new Thread(){

                public void run() {
                    JGRConsole.this.setWorking(true);
                    JGRHelp.current.show();
                    JGRHelp.current.toFront();
                    JGRHelp.current.requestFocus();
                    try {
                        JGRHelp.current.search(string3, bl2);
                    }
                    catch (Exception exception) {
                        new ErrorMsg(exception);
                    }
                    JGRConsole.this.setWorking(false);
                }
            };
            thread.start();
        } else {
            JGRHelp.current.show();
            JGRHelp.current.toFront();
            JGRHelp.current.requestFocus();
        }
    }

    public void clearconsole() {
        try {
            if (this.clearpoint == null) {
                this.clearpoint = new Integer(this.output.getLineEndOffset(this.output.getLineOfOffset(this.end) - 1) + 2);
            }
            this.output.removeAllFrom(this.clearpoint);
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void loadWorkSpace() {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), "Open Workspace", 0, JGRPrefs.workingDirectory);
        fileSelector.setVisible(true);
        if (fileSelector.getFile() != null) {
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            this.wspace = JGRPrefs.workingDirectory + fileSelector.getFile();
            this.execute("load(\"" + this.wspace.replace('\\', '/') + "\")", false);
        }
    }

    public void saveWorkSpace(String string) {
        if (string == null) {
            this.execute("save.image()", false);
        } else {
            this.execute("save.image(\"" + (string == null ? "" : string.replace('\\', '/')) + "\",compress=TRUE)", false);
        }
        JGR.writeHistory();
    }

    public void saveWorkSpaceAs() {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), "Save Workspace as...", 1, JGRPrefs.workingDirectory);
        fileSelector.setVisible(true);
        if (fileSelector.getFile() != null) {
            JGRPrefs.workingDirectory = fileSelector.getDirectory();
            String string = JGRPrefs.workingDirectory + fileSelector.getFile();
            this.saveWorkSpace(string);
            JGR.writeHistory();
        }
    }

    public int getFontWidth() {
        int n = this.output.getFontMetrics(this.output.getFont()).charWidth('M');
        n = this.output.getWidth() / n;
        return n - (JGRPrefs.isMac ? 0 : 1);
    }

    public void rWriteConsole(Rengine rengine, String string, int n) {
        this.console.append(string);
        if (this.console.length() > 100) {
            this.output.append(this.console.toString(), JGRPrefs.RESULT);
            this.console.delete(0, this.console.length());
            this.output.setCaretPosition(this.outputDoc.getLength());
        }
    }

    public void rWriteConsole(Rengine rengine, String string) {
        this.rWriteConsole(rengine, string, 0);
    }

    public void rBusy(Rengine rengine, int n) {
        if (n == 0) {
            if (this.console != null) {
                this.output.append(this.console.toString(), JGRPrefs.RESULT);
                this.console.delete(0, this.console.length());
            }
            this.output.setCaretPosition(this.outputDoc.getLength());
            this.setWorking(false);
        } else {
            this.toolBar.stopButton.setEnabled(true);
            this.setWorking(true);
        }
    }

    public String rReadConsole(Rengine rengine, String string, int n) {
        this.toolBar.stopButton.setEnabled(false);
        if (string.indexOf("Save workspace") > -1) {
            String string2 = JGR.exit();
            if (this.wspace != null && string2.indexOf(121) >= 0) {
                JGR.R.eval("save.image(\"" + this.wspace.replace('\\', '/') + "\")");
                return "n\n";
            }
            return string2;
        }
        this.output.append(string, JGRPrefs.CMD);
        this.output.setCaretPosition(this.outputDoc.getLength());
        String string3 = JGR.rSync.waitForNotification();
        try {
            this.outputDoc.insertString(this.outputDoc.getLength(), string3 + "\n", JGRPrefs.CMD);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string3 == null || string3.length() == 0 ? "\n" : string3 + "\n";
    }

    public void rShowMessage(Rengine rengine, String string) {
        JOptionPane.showMessageDialog((Component)((Object)this), string, "R Message", 1);
    }

    public String rChooseFile(Rengine rengine, int n) {
        FileSelector fileSelector = new FileSelector((Frame)((Object)this), n == 0 ? "Select a file" : "Select a new file", n == 0 ? 0 : 1, JGRPrefs.workingDirectory);
        fileSelector.setVisible(true);
        String string = null;
        if (fileSelector.getDirectory() != null && fileSelector.getFile() != null) {
            string = fileSelector.getDirectory();
        }
        if (fileSelector.getFile() != null) {
            string = string == null ? fileSelector.getFile() : string + fileSelector.getFile();
        }
        return string;
    }

    public void rFlushConsole(Rengine rengine) {
    }

    public void rLoadHistory(Rengine rengine, String string) {
        File file = null;
        try {
            file = new File(string);
            if (file.exists()) {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                if (JGR.RHISTORY == null) {
                    JGR.RHISTORY = new Vector();
                }
                while (bufferedReader.ready()) {
                    JGR.RHISTORY.add(bufferedReader.readLine() + "\n");
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void rSaveHistory(Rengine rengine, String string) {
        try {
            System.out.println("Save History");
            File file = new File(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            Enumeration enumeration = JGR.RHISTORY.elements();
            boolean bl = false;
            while (enumeration.hasMoreElements()) {
                bufferedWriter.write(enumeration.nextElement().toString() + "#\n");
            }
            bufferedWriter.flush();
            bufferedWriter.close();
        }
        catch (Exception exception) {
            new ErrorMsg(exception);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "about") {
            new AboutDialog((JFrame)((Object)this));
        } else if (string == "cut") {
            this.input.cut();
        } else if (string == "clearwsp") {
            this.execute("rm(list=ls())", false);
        } else if (string == "copy") {
            this.input.copy();
            this.output.copy();
        } else if (string == "copyoutput") {
            this.output.copyOutput();
        } else if (string == "copycmds") {
            this.output.copyCommands();
        } else if (string == "copyresult") {
            this.output.copyResults();
        } else if (string == "clearconsole") {
            this.clearconsole();
        } else if (string == "delete") {
            try {
                int n = 0;
                n = this.input.getSelectionStart();
                this.inputDoc.remove(n, this.input.getSelectionEnd() - n);
            }
            catch (BadLocationException badLocationException) {}
        } else if (string == "editor") {
            new Editor();
        } else if (string == "exit") {
            this.dispose();
        } else if (string == "exportOutput") {
            this.output.startExport();
        } else if (string == "fontBigger") {
            FontTracker.current.setFontBigger();
        } else if (string == "fontSmaller") {
            FontTracker.current.setFontSmaller();
        } else if (string == "loaddata") {
            new JGRDataFileOpenDialog((Frame)((Object)this), JGRPrefs.workingDirectory);
        } else if (string == "open") {
            new Editor().open();
        } else if (string == "openwsp") {
            this.loadWorkSpace();
        } else if (string == "new") {
            new Editor();
        } else if (string == "objectmgr") {
            this.execute("object.browser()", false);
        } else if (string == "packagemgr") {
            this.execute("package.manager()", false);
        } else if (string == "paste") {
            this.input.paste();
        } else if (string == "preferences") {
            new PrefsDialog((JFrame)((Object)this));
        } else if (string == "redo") {
            try {
                if (this.toolBar.undoMgr.canRedo()) {
                    this.toolBar.undoMgr.redo();
                }
            }
            catch (CannotUndoException cannotUndoException) {}
        } else if (string == "help") {
            this.execute("help.start()", false);
        } else if (string == "table") {
            new DataTable(null, null, true);
        } else if (string == "save") {
            this.output.startExport();
        } else if (string == "savewsp") {
            this.saveWorkSpace(this.wspace);
        } else if (string == "saveaswsp") {
            this.saveWorkSpaceAs();
        } else if (string == "search") {
            FindReplaceDialog.findExt((Frame)((Object)this), this.output);
        } else if (string == "searchnext") {
            FindReplaceDialog.findNextExt((Frame)((Object)this), this.output);
        } else if (string == "source") {
            this.execute("source(file.choose())", false);
        } else if (string == "stop") {
            JGR.R.rniStop(1);
        } else if (string == "selAll") {
            if (this.input.isFocusOwner()) {
                this.input.selectAll();
            } else if (this.output.isFocusOwner()) {
                this.output.selectAll();
            }
        } else if (string == "undo") {
            try {
                if (this.toolBar.undoMgr.canUndo()) {
                    this.toolBar.undoMgr.undo();
                }
            }
            catch (Exception exception) {}
        } else if (string == "setwd") {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setDialogTitle("Choose Working Directory");
            jFileChooser.setApproveButtonText("Choose");
            int n = jFileChooser.showOpenDialog((Component)((Object)this));
            if (n == 1) {
                return;
            }
            if (jFileChooser.getSelectedFile() != null) {
                JGRPrefs.workingDirectory = jFileChooser.getSelectedFile().toString();
            }
            this.execute("setwd(\"" + jFileChooser.getSelectedFile().toString().replace('\\', '/') + "\")", true);
        } else if (string == "update") {
            this.execute("update.JGR(contriburl=\"http://rosuda.org/R/nightly\")", false);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.output) && !keyEvent.isMetaDown() && !keyEvent.isControlDown() && !keyEvent.isAltDown()) {
            this.input.requestFocus();
        }
        if (keyEvent.getKeyCode() == 38) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible()) {
                this.input.mComplete.selectPrevious();
            } else if (this.currentHistPosition > 0 && (this.input.getCaretPosition() == 0 || this.input.getCaretPosition() == this.input.getText().length())) {
                this.input.setText(JGR.RHISTORY.get(--this.currentHistPosition).toString());
                this.input.setCaretPosition(this.input.getText().length());
                this.wasHistEvent = true;
            }
        } else if (keyEvent.getKeyCode() == 40) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible()) {
                this.input.mComplete.selectNext();
            } else if (this.input.getCaretPosition() == 0 || this.input.getCaretPosition() == this.input.getText().length()) {
                if (this.currentHistPosition < JGR.RHISTORY.size() - 1) {
                    this.input.setText(JGR.RHISTORY.get(++this.currentHistPosition).toString());
                    this.input.setCaretPosition(this.input.getText().length());
                } else if (JGR.RHISTORY.size() > 0 && this.currentHistPosition < JGR.RHISTORY.size()) {
                    this.input.setText("");
                    ++this.currentHistPosition;
                }
                this.wasHistEvent = true;
            }
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (this.input.mComplete != null && this.input.mComplete.isVisible() && !keyEvent.isControlDown() && !keyEvent.isMetaDown()) {
                this.input.mComplete.completeCommand();
            } else if (keyEvent.isControlDown() || keyEvent.isMetaDown()) {
                try {
                    this.inputDoc.insertString(this.input.getCaretPosition(), "\n", null);
                    this.input.mComplete.setVisible(false);
                }
                catch (Exception exception) {}
            } else {
                String string = this.input.getText().trim();
                this.input.setText("");
                this.input.setCaretPosition(0);
                this.input.requestFocus();
                this.execute(string, true);
            }
        }
        if (keyEvent.getSource().equals(this.output) && keyEvent.getKeyCode() == 86 && (keyEvent.isControlDown() || keyEvent.isMetaDown())) {
            this.input.requestFocus();
            this.input.paste();
            this.input.setCaretPosition(this.input.getText().length());
        } else if ((keyEvent.getKeyCode() == 38 || keyEvent.getKeyCode() == 40) && this.wasHistEvent) {
            this.wasHistEvent = false;
            this.input.setCaretPosition(this.input.getText().length());
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getSource().equals(this.output)) {
            this.toolBar.cutButton.setEnabled(false);
            EzMenu.getItem((Frame)((Object)this), (String)"cut").setEnabled(false);
            this.toolBar.pasteButton.setEnabled(false);
            EzMenu.getItem((Frame)((Object)this), (String)"paste").setEnabled(false);
        } else if (focusEvent.getSource().equals(this.input)) {
            this.toolBar.cutButton.setEnabled(true);
            EzMenu.getItem((Frame)((Object)this), (String)"cut").setEnabled(true);
            this.toolBar.pasteButton.setEnabled(true);
            EzMenu.getItem((Frame)((Object)this), (String)"paste").setEnabled(true);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

