#' Defunct and depreciated functions
#' 
#' The function you asked help for has been defunct (i.e. it does not longer
#' exists) or depreciated (i.e. it will disappear soon). A new function with a
#' different name is surely doing the old job.
#' 
#' @param ... The call of the defunct or depreciated function
#' @aliases Calibfit GetElev Isofit Isorix Isoscape Isosim QueryGNIP queryGNIP prepdata prepelev prepiso RElevate relevate
#' @name IsoriX-defunct
NULL

#' @rdname IsoriX-defunct
#' @export
Calibfit <- function(...) {
  .Defunct("calibfit")
}

#' @rdname IsoriX-defunct
#' @export
GetElev <- function(...) {
  .Defunct("getelev")
}

#' @rdname IsoriX-defunct
#' @export
Isofit <- function(...) {
  .Defunct("isofit")
}

#' @rdname IsoriX-defunct
#' @export
Isorix <- function(...) {
  .Defunct("isofind")
}

#' @rdname IsoriX-defunct
#' @export
Isoscape <- function(...) {
  .Defunct("isoscape")
}

#' @rdname IsoriX-defunct
#' @export
Isosim <- function(...) {
  .Defunct("isosim")
}

#' @rdname IsoriX-defunct
#' @export
QueryGNIP <- function(...) {
  .Defunct("prepsources")
}

#' @rdname IsoriX-defunct
#' @export
queryGNIP <- function(...) {
  .Defunct("prepsources")
}

#' @rdname IsoriX-defunct
#' @export
prepdata <- function(...) {
  .Defunct("prepsources")
}

#' @rdname IsoriX-defunct
#' @export
prepelev <- function(...) {
  .Defunct("prepraster")
}

#' @rdname IsoriX-defunct
#' @export
prepiso <- function(...) {
  .Defunct("prepsources")
}

#' @rdname IsoriX-defunct
#' @export
RElevate <- function(...) {
  .Defunct("prepraster")
}

#' @rdname IsoriX-defunct
#' @export
relevate <- function(...) {
  .Defunct("prepraster")
}
