% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IsoriX-dataset.R
\docType{data}
\name{AssignDataAlien}
\alias{AssignDataAlien}
\title{Simulated assignment dataset}
\format{A \var{dataframe} with 10 observations on 2 variables:
\tabular{rlll}{ [, 1] \tab animalID \tab (\var{Factor}) \tab Identification
of the animal\cr [, 2] \tab tissue.value \tab (\var{numeric}) \tab Deuterium delta
value of the tissue\cr }}
\description{
This dataset contains simulated deuterium delta values. 
The data can be used as an example to perform assignments using the function \code{\link{isofind}}.
}
\examples{

head(AssignDataAlien)
str(AssignDataAlien)

## The examples below will only be run if sufficient time is allowed
## You can change that by typing e.g. IsoriX.options(example_maxtime = XX)
## if you want to allow for examples taking up to ca. XX seconds to run
## (so don't write XX but put a number instead!)

if(IsoriX.getOption("example_maxtime") > 30) {

## We prepare the precipitation data
GNIPDataDEagg <- prepdata(data = GNIPDataDE)

## We fit the models for Germany
GermanFit <- isofit(iso.data = GNIPDataDEagg)

## We build the isoscape
isoscape <- isoscape(elevation.raster = ElevRasterDE, isofit = GermanFit)

## We create a simulated dataset with 1 site and 10 observations
set.seed(1L)
Aliens <- create_aliens(calib_fn = list(intercept = 3, slope = 0.5, resid_var = 5),
                        isoscape = isoscape,
                        elevation_raster = ElevRasterDE,
                        coordinates = data.frame(siteID = "Berlin",
                                                 long   = 13.52134,
                                                 lat    = 52.50598),
                        n_sites = 1,
                        min_n_samples = 10,
                        max_n_samples = 10)
AssignDataAlien <- Aliens[, c("animalID", "tissue.value")]

## Uncomment the following to store the file as we did
#save(AssignDataAlien, file = "AssignDataAlien.rda", compress = "xz")

}

}
\seealso{
\code{\link{isofind}} to perform assignments
}
\keyword{datasets}
