% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibfit.R
\name{calibfit}
\alias{calibfit}
\alias{print.calibfit}
\alias{summary.calibfit}
\title{Fit the calibration model}
\usage{
calibfit(calib.data, isofit, verbose = interactive(),
  control.optim = list())
}
\arguments{
\item{calib.data}{A \var{dataframe} containing the calibration data (see
note below)}

\item{isofit}{The fitted isoscape model created by \code{\link{isofit}}}

\item{verbose}{A \var{logical} indicating whether information about the
progress of the procedure should be displayed or not while the function is
running. By default verbose is \var{TRUE} if users use an interactive R
session and \var{FALSE} otherwise.}

\item{control.optim}{A \var{list} to pass information to the argument
control of the optim call (for advanced users only).}
}
\value{
This function returns a \var{list} of class \var{calibfit}
containing the fixed-effect estimates of the calibration function, the
covariance of the fixed effects, the fitted calibration model, the original
calibration data set with additional information added during the fit, and
the location of the calibration points as spatial points.
}
\description{
This function fits a model that establishes the relationship between the 
isotopic values of organisms (e.g. tissues such as hair, horn, ivory or 
feathers) and the isotopic values of their environment (e.g. precipitation).
}
\details{
The calibration model is a linear mixed-effects model (LMM) that fits the 
isotopic values of sedentary organisms as a linear function of the isotopic 
values in their environment (e.g. precipitation).

This function considers that the isotopic values from the environment (e.g.
from precipitation) at the locations at which organisms were sampled are not
known. The function therefore predicts these isotopic values from the
geostatistical model fitted by the function \code{\link{isofit}}, which is
provided to \code{\link{calibfit}} using the argument \code{isofit}.

The LMM used to fit the calibration function has a simple fixed-effect
structure: an intercept and a slope. The random effect is more complex: it is
normally distributed with mean zero, a certain variance between locations
proportional to the squared fixed slope, and a covariance structure defined
by the prediction covariance matrix of the isoscape model between the
calibration locations. All models used in \pkg{IsoriX} will be soon detailed
in an additional document.

This function is only needed in the case for which the assignment of
organisms has to be performed within an isoscape that was built using another
source of isotopic values (e.g., precipitation). This implies that if the
isoscape had been fitted using isotopic ratios from sedentary animals, then
this calibration step is not needed.

If source isotopic values are known at the locations where sedentary
organisms were sampled, users should calibrate their data directly using the
function \code{\link[stats]{lm}} by fitting tissue isotopic values as a
function of source isotopic values.
}
\note{
See \code{\link{CalibDataAlien}} to know which variables are needed to
perform the calibration fit and their names.
}
\examples{

## The examples below will only be run if sufficient time is allowed
## You can change that by typing e.g. IsoriX.options(example_maxtime = XX)
## if you want to allow for examples taking up to ca. XX seconds to run
## (so don't write XX but put a number instead!)

if(IsoriX.getOption("example_maxtime") > 30) {

## We fit the models for Germany:
GNIPDataDEagg <- queryGNIP(data = GNIPDataDE)

GermanFit <- isofit(iso.data = GNIPDataDEagg)

## We fit the calibration model:
calib <- calibfit(calib.data = CalibDataAlien, isofit = GermanFit)

## We display minimal information:
calib

## We display more information:
summary(calib)

## We plot the calibration function:
plot(calib)

}

}
\seealso{
\code{\link{IsoriX}} for the complete workflow
}
\keyword{models}
\keyword{regression}
