% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/errorellipse.R
\name{ellipse}
\alias{ellipse}
\title{Get coordinates of error ellipse for plotting}
\usage{
ellipse(x, y, covmat, alpha = 0.05, n = 50)
}
\arguments{
\item{x}{x-coordinate (scalar) for the centre of the ellipse}

\item{y}{y-coordinate (scalar) for the centre of the ellipse}

\item{covmat}{the [\code{2 x 2}] covariance matrix of the x-y coordinates}

\item{alpha}{the probability cutoff for the error ellipses}

\item{n}{the resolution (number of segments) of the error ellipses}
}
\value{
an [\code{n x 2}] matrix of plot coordinates
}
\description{
Constructs an error ellipse at a given confidence level from its
centre and covariance matrix
}
\examples{
x = 99; y = 101;
covmat <- matrix(c(1,0.9,0.9,1),nrow=2)
ell <- ellipse(x,y,covmat)
plot(c(90,110),c(90,110),type='l')
polygon(ell,col=rgb(0,1,0,0.5))
points(x,y,pch=21,bg='black')
}
