% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ising_grid.R
\name{make_Ising_grid-control-functions}
\alias{make_Ising_grid-control-functions}
\alias{single_threshold}
\alias{single_wei}
\alias{all_thresholds}
\alias{whole_weiadj}
\alias{beta_list}
\title{Control Functions to Specify the Varying Parameters for
an Ising Grid.}
\usage{
single_threshold(pos, seq, .f = `*`)

single_wei(pos, seq, .f = `*`)

all_thresholds(seq, .f = `*`)

whole_weiadj(seq, .f = `*`)

beta_list(seq, .f = `*`)
}
\arguments{
\item{pos}{The position of the single threshold or the weight
value that should vary across Ising networks. Should be a single
number for \code{\link[=single_threshold]{single_threshold()}} or a numeric vector of
length 2 for \code{\link[=single_wei]{single_wei()}}.}

\item{seq}{A vector that specify the values. Can be generated
with \code{\link[base:seq]{base::seq()}}.}

\item{.f}{What calculation should be done for \code{seq}
and the original threshold value(s) or the original weight(ed
adjacency matrix)? \code{*} by default, which means the values supplied
in \code{seq} will be multiplied to the original value, vector, or matrix.}
}
\value{
An \verb{ctrl_*} object specifying the varying parameters.
}
\description{
Control Functions to Specify the Varying Parameters for
an Ising Grid.
}
