% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{overlaps}
\alias{overlaps}
\alias{intersects}
\alias{unions}
\alias{setdiffs}
\title{Compute overlaps of two sets of detached and sorted intervals}
\usage{
overlaps(x, y, check = TRUE, in_x = TRUE, in_y = TRUE, op = "and")

intersects(x, y, ...)

unions(x, y, ...)

setdiffs(x, y, ...)
}
\arguments{
\item{x}{Integer matrix of two columns, the first column giving the (inclusive) start points of intervals and the second column giving the corresponding (exclusive) end points.}

\item{y}{Same as \code{x}.}

\item{check}{Boolean value determining whether to check that the intervals specified in arguments \code{x} and \code{y} are sorted and non-overlapping (uses function \code{\link{detached_sorted_nonempty}}). Defaults to \code{TRUE}, but setting to \code{FALSE} may allow faster execution.}

\item{in_x}{Boolean value determining whether to flag \code{TRUE} on intervals contained in \code{x}.}

\item{in_y}{Boolean value determining whether to flag \code{TRUE} on intervals contained in \code{y}.}

\item{op}{Character value specifying operator used to combine flags for each interval, either \code{"and"} or \code{"or"}.}

\item{...}{Additional arguments to be passed to \code{overlaps}.}
}
\value{
Intervals represented by integer matrix of two columns.
}
\description{
Find intervals satisfying particular conditions, including corresponding base R functions \code{intersect} (i.e. find intersections of intervals), \code{union} (i.e. unions of intervals) and \code{setdiff} (i.e. finding intervals which are contained in one set of intervals but not another).
}
\examples{
intersects(cbind(1, 3), cbind(2, 4))
setdiffs(cbind(1, 3), cbind(2, 4))
unions(cbind(1, 3), cbind(2, 4))
}
