% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods-sum.R
\docType{methods}
\name{sum}
\alias{sum}
\alias{sum,IntervalList-method}
\title{Calculate the sum of \eqn{n} interval-valued data}
\usage{
\S4method{sum}{IntervalList}(x)
}
\arguments{
\item{x}{a list of interval-valued data.}
}
\value{
Returns the calculated sum of \eqn{n} interval-valued data, i.e., other interval-valued data.
}
\description{
This function calculates the sum of \eqn{n} interval-valued data.
}
\examples{
sum(IntervalList(c(1, 3), c(2, 5)))
}
\references{
Hankin, R.K.S. (2010). A step-by-step guide to writing a simple package that uses S4 methods:
a "hello world" example. Technical Report. Auckland University of Technology.
}
\seealso{
Other IntervalList-method: 
\code{\link{IntervalList-class}},
\code{\link{IntervalList}},
\code{\link{as.IntervalList}()},
\code{\link{cov}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{mean}()},
\code{\link{plot}()},
\code{\link{var}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalList-method}
