% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalMatrix.R
\name{IntervalMatrix}
\alias{IntervalMatrix}
\title{Create an \code{IntervalMatrix} object}
\usage{
IntervalMatrix(data, type = 1)
}
\arguments{
\item{data}{a matrix or data frame containing the interval-valued data information.}

\item{type}{a number specifying the characterisation that is being used.
Only four options are allowed:
\itemize{
\item \code{1}: inf/sup-characterisation is used variable by variable (default).
\item \code{2}: mid/spr-characterisation is used variable by variable.
\item \code{3}: all infimums are followed by all supremums in the same variable order.
\item \code{4}: all mid-points are followed by all spreads in the same variable order.
}}
}
\value{
Object of class \code{\linkS4class{IntervalMatrix}}.
}
\description{
For convenience, objects of class \code{IntervalMatrix}
may be created with this function.
}
\examples{
data <- matrix(c(0, 2, 0, 4, 1, 3, 3, 9), 2, 4, byrow = TRUE)
IntervalMatrix(data)
data <- matrix(c(1, 1, 2, 2, 2, 1, 6, 3), 2, 4, byrow = TRUE)
IntervalMatrix(data, 2)
data <- matrix(c(0, 0, 2, 4, 1, 3, 3, 9), 2, 4, byrow = TRUE)
IntervalMatrix(data, 3)
data <- matrix(c(1, 2, 1, 2, 2, 6, 1, 3), 2, 4, byrow = TRUE)
IntervalMatrix(data, 4)

}
\seealso{
Other IntervalMatrix-method: 
\code{\link{IntervalMatrix-class}},
\code{\link{apply}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{show}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalMatrix-method}
