% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IntervalList.R
\name{IntervalList}
\alias{IntervalList}
\title{Create an \code{IntervalList} object}
\usage{
IntervalList(x, y = NULL, type = 1)
}
\arguments{
\item{x}{a numeric vector, matrix or data frame.}

\item{y}{NULL (default) or a numeric vector with compatible dimensions to \code{x}.}

\item{type}{a number specifying the order and the characterisation that is being used.
Only two options are allowed:
\itemize{
\item \code{1}: inf/sup-characterisation is used (default).
\item \code{2}: mid/spr-characterisation is used.
}}
}
\value{
Object of class \code{\linkS4class{IntervalList}}.
}
\description{
For convenience, objects of class \code{IntervalList}
may be created with this function.
}
\examples{
IntervalList(c(0, 2, 5), c(1, 6, 10))
IntervalList(c(0.5, 4, 7.5), c(0.5, 2, 2.5), 2)
IntervalList(matrix(c(0, 2, 5, 1, 6, 10), 3, 2))
IntervalList(matrix(c(0.5, 4, 7.5, 0.5, 2, 2.5), 3, 2), type = 2)

}
\seealso{
Other IntervalList-method: 
\code{\link{IntervalList-class}},
\code{\link{as.IntervalList}()},
\code{\link{cov}()},
\code{\link{ivd2likert}()},
\code{\link{ivd2vas}()},
\code{\link{mean}()},
\code{\link{plot}()},
\code{\link{sum}()},
\code{\link{var}()}
}
\author{
Jose Garcia Garcia \email{garciagarjose@uniovi.es}
}
\concept{IntervalList-method}
