% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{FeatSelection}
\alias{FeatSelection}
\title{feature selection for a selection of objects}
\usage{
FeatSelection(List, Selection = NULL, binData = NULL, contData = NULL,
  datanames = NULL, nrclusters = NULL, topChar = NULL, sign = 0.05,
  fusionsLog = TRUE, weightclust = TRUE)
}
\arguments{
\item{List}{A list of the clustering outputs to be compared. The first
element of the list will be used as the reference in
\code{ReorderToReference}.}

\item{Selection}{If differential gene expression should be investigated for
a specific selection of objects, this selection can be provided here.
Selection can be of the type "character" (names of the objects) or
"numeric" (the number of specific cluster). Default is NULL.}

\item{binData}{A list of the binary feature data matrices. These will be
evaluated with the fisher's extact test. Default is NULL.}

\item{contData}{A list of continuous data sets of the objects. These will
be evaluated with the t-test. Default is NULL.}

\item{datanames}{A vector with the names of the data matrices. Default is NULL.}

\item{nrclusters}{Optional. The number of clusters to cut the dendrogram in.
The number of clusters should not be specified if the interest lies only in
a specific selection of objects which is known by name.  Otherwise, it is
required. Default is NULL.}

\item{topChar}{Overrules sign. The number of features to display for each
cluster.  If not specified, only the significant genes are shown. Default is NULL.}

\item{sign}{The significance level to be handled. Default is 0.05.}

\item{fusionsLog}{Logical. To be handed to \code{ReorderToReference}: indicator for the fusion of clusters. Default is TRUE}

\item{weightclust}{Logical. To be handed to \code{ReorderToReference}: to be used for the outputs of CEC,
WeightedClust or WeightedSimClust. If TRUE, only the result of the Clust element is considered. Default is TRUE.}
}
\description{
Internal function of \code{CharacteristicFeatures}.
}
