% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ReportSTRING.R
\name{ReportSTRING}
\alias{ReportSTRING}
\title{This function generates a STRING based network using the significant melt shifts from analysis}
\usage{
ReportSTRING(Data_Melts, STRINGScore, Directory, Species, PValMeltFDR)
}
\arguments{
\item{Data_Melts}{abundance and fit data for proteins that meet quality criteria in overall workflow}

\item{STRINGScore}{the STRING score that is used to determine whether an interaction is significant}

\item{Directory}{directory where results are saved}

\item{Species}{species taxon number for bioinformatics search}

\item{PValMeltFDR}{Whether or not the FDR correction for pvalue is used in designation of melts of interest}
}
\value{
Excel files with summary of data along with melt curve plots for significant proteins
}
\description{
This function generates a STRING based network using the significant melt shifts from analysis
}
\examples{
\dontrun{
ReportSTRING(Data_Melts,STRINGScore,Directory,Species,PValMeltFDR)
}
}
