% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitGrowthCurvesGrouped.R
\name{fitGrowthCurvesGrouped}
\alias{fitGrowthCurvesGrouped}
\title{fitGrowthCurvesGrouped}
\usage{
fitGrowthCurvesGrouped(idrc_set)
}
\arguments{
\item{idrc_set}{IncucyteDRCSet object}
}
\value{
IncucyteDRCSet object
}
\description{
Function to fit loess function to the growth curve data in an IncucyteDRCSet object
}
\examples{
pm_file <- system.file(file='extdata/example.PlateMap', package='IncucyteDRC')
test_pm <- importPlatemapXML(pm_file)
data_file <- system.file(file='extdata/example_data.txt', package='IncucyteDRC')
test_data <- importIncucyteData(data_file, metric='pc')

test_list <- splitIncucyteDRCPlateData(test_pm, test_data, group_columns='growthcondition')

print(test_list)

test_idrc_set <- fitGrowthCurvesGrouped(test_list[[2]])

}

